\name{panelDesc}
\alias{panelDesc}
\docType{data}
\title{micromapST panel description data.frame structure }

\description{
  The \code{panelDesc} data.frame provides the information required to process the 
  \code{stateFrame} data and to generate the required linked micromap plot.  
  It specifies where the data is in the \code{stateFrame} data.frame, 
  the column types, labels, and reference values and text.

  \preformatted{
  Example
    panelDesc = data.frame(
        type=c("mapcum","id","dotconf","dotconf"),
        lab1=c("","","White Males","White Females"),
        lab2=c("","","Rate and 95\% CI","Rate and 95\% CI"),
        lab3=c("","","Deaths per 100,000","Deaths per 100,000"),
        col1=c(NA,NA,2,9), 
        col2=c(NA,NA,4,11),
        col3=c(NA,NA,5,12),
        refVals=c(NA,NA,NA,wflungUS[,1]),
        refTexts=c(NA,NA,NA,"US Rate"),
        panelData=c("","","","")
     )
  }
  The \code{panelDesc} data.frame (or a similar data.frame variable) is the primary vehicle 
  for defining how to reference the data in the \code{stateFrame} data.frame when creating 
  the state linked micromap plot.  

  micromapST supports up to 3 column labels (titles): \code{lab1}, \code{lab2} and \code{lab3}. 
  Generally \code{lab3} is used to indicate the unit of measure at the bottom of the columns.

  Depending on the type of graphic selected for the column, 1 to 3 data values will be
  needed per state: \code{col1}, \code{col2}, and \code{col3}. The \code{col1}, \code{col2} and 
  \code{col3} numeric vectors serve as indexes to columns in a data.frame passed to 
  \code{micromapST} when it is called. If no index is required, 'NA' should be specified.
}

\usage{panelDesc}

\format{
 The parameters in the panelDesc data.frame structure are:
 \describe{
   \item{type=}{The types of graphics for each column of panels can 
     be specified by the following keywords in the 'type variable': 
  
     \describe{
       \item{Maps:}{'map', 'mapcum','maptail','mapmedian',}
       \item{State ID and/Name:}{'id',} 
       \item{Graphics:}{'dot', 'dotse','dotconf', 'bar', 'arrow', 'ts', 'tsconf','scatdot', 'segbar', 'normbar', 'ctrbar', 'boxplot'}
     }
     
     The following provides a description of each panel type:
     
     \describe{
       \item{\code{'map'}}{a non-highlighted map}
       \item{\code{'mapcum'}}{maps show the accumulated states top to bottom}
       \item{\code{'maptail'}}{maps show the accumulated states from the extremes in toward median}
       \item{\code{'mapmedian'}}{maps show states above and below the median state}
     }
     
     
     \describe{
       \item{\code{'id'}}{the state 2 character abbreviation or the full state name controlled by 'rownames' variable in the 
         micromapST call.}
     }
     
     
     \describe{
       \item{\code{'dot'}}{a dot for a single value.}
       \item{\code{'dotse'}}{a dot and its standard error.}
       \item{\code{'dotconf'}}{a dot and its confidence interval using three values.}
     }
     
     
     \describe{
       \item{\code{'bar'}}{a bar for a single value (will accept negative values and plot 
       from 0 in that direction).}
     }
     
     
     \describe{
       \item{\code{'arrow'}}{an arrow from value 1 to value 2.}
     }
     
     
     \describe{
       \item{\code{'boxplot'}}{a boxplot for each state using the data.frame generated by the 
         boxplot function.  This data.frame is passed as a separate variable to 
         micromapST using the colData column.}
     }
     
     
     \describe{
       \item{\code{'ts'}}{a time series line plot for each state. The data required to 
         plot the time series is passed to micromapST using the panelData column as 
         an array 51 by 't' by 2 where t is the number of time periods.\cr         
         Both the time series values (y) and the time periods (x) need to be input.}
       \item{\code{'tsconf'}}{a time series line and confidence interval band for each state.
         The data required for the plot is passed to micromapST using the 
         panelData column as an array 51 by 't' by 4, where t is the number 
         of time periods.}
     }
     
     
     \describe{
       \item{\code{'segbar'}}{a horizontal stacked (segmented) bar plot starting at 0 using data in the 
         stateFrame data.frame.  The col1 and col2 columns are used to indicate the first 
         and last columns in the stateFrame data.frame that contain the contiguous bar segment values.}
       \item{\code{'normbar'}}{a stacked bar plot where the data is normalized for 
         each state by dividing the bar segment values by the sum of the 
         values for all of the bars.  The stacked bar plot for each state
         then ranges from 0 to 100\% (edge to edge).  The col1 and col2 columns 
         are used to indicate the first and last columns in the stateFrame
         data.frame that contain the contiguous bar segment values.}
       \item{\code{'ctrbar'}}{a stacked bar plot where the bar segments are centered around 
         the middle of the data. If there is an even number of segments, the 0 point is 
         between the lower half and the upper half of the segments.  If there is an odd 
         number of segments, the center is the midpoint of the middle segment. The other segments 
         are plotted to the left and right of the center point. The col1 and col2 columns 
         are used to indicate the first and last columns in the stateFrame data.frame that 
         contain the contiguous bar segment values.}
      }
     
     
      \describe{
       \item{\code{'scatdot'}}{a set of 51 points with (x,y) coordinates. All points 
         are plotted in each panel with the key states in the panel highlighted.}
      }


   Example: \code{type=c('id','map','boxplot')}  
      To specify a micromapST with three columns, left to right,
      containing the state label, a map and a boxplot.
   }
   \item{col1=, col2=, col3=}{Index numbers of columns in stateFrame to be used as data for graphics.  
      'Map', 'id' and  'boxplots', 'ts', and 'tsconf' graphics do not use the \code{col1}, \code{col2}, or \code{col3} 
      indexes to data and the corresponding entires should be 'NA'.
  
      \describe{
       
        \item{\code{'dot'}}{uses \code{col1} to specify the data column to be ploted.}
        \item{\code{'dotse'}}{uses \code{col1} and \code{col2} to specify the data columns 
           to use as the estimate and standard error values, 
           respectively.}
        \item{\code{'dotconf'}}{uses \code{col1}, \code{col2}, and \code{col3} to specify the data 
           columns for the estimate, lower confidence interval, and upper confidence interval values.
           }
        
        \item{\code{'bar'}}{uses \code{col1} to specify the data column for the length
           of the bar.  The data value can be positive or negative.
           }
      
        \item{\code{'arrow'}}{uses \code{col1} and \code{col2} to specify the data columns 
           for the beginning and end values of the arrow.
           }
      
        \item{\code{'segbar'}, \code{'normbar'}, \code{'ctrbar'}}{uses \code{col1} and \code{col2} to specify the
           data columns for the first and last columns in the stateFrame.
           Data is used from contiguous columns starting from col1 to col2,
           with a minimum of 2 columns and a maximum of 30 columns.
           }
           
        \item{\code{'scatdot'}}{uses \code{col1} and \code{col2} to specify the x and y values for a
           dot for each of the 51 states and DC in a scatter plot.
           }
       }
   }      
   \item{lab1=, lab2=}{
     Character vectors provide the two column labels (titles) lines at the top of a column. 
     If no label is required, use \code{''} for a blank line.
   }
   \item{lab3=}{
     Character vector used as a label at the bottom of the column. This is typically used 
     to show units of measure.  If no label is required, use \code{''} for a blank line.
   }
   \item{lab4=}{
     Character vector used as the vertical (y) axis label for 'ts', 'tsconf', and 'scatdot' graphics.
     If no label is required, use \code{''} for a blank line.
   }
 
   \item{refVals=}{
     Is a list of object names providing the reference values for each graphic column. 
     The reference value is displayed as a dashed vertical line for each panel in the specified column.
   }
   \item{refTexts=}{
     Is a list of labels displayed at the 
     bottom of each column to identify the reference value.
   }
 
   \item{panelData=}{
     List of object names containing the boxplot data list and/or an array of time series 
     data for each state.  If boxplot and time series data are not used in a column, 
     then associated object names should be \code{'NA'}.
     
     For \code{boxplot} data, each row name in the boxplot list must be the state 
     abbreviation (2 character) for the state associated with the data. There must 
     be 51 rows in the data.frame. Each row must be data produced by the \code{boxplot} function.
     
     For time series data, the object is a 3 dimensional array (51 by t by 2 (or 4)), 
     where t is the number of time periods or, in general, the number of pairs of (x,y) values to plot. 
     
     For time series without confidence bounds, \code{inputdataframe[,,1]} contains the x values 
     and \code{inputdataframe[,,2]} contains the y values for the points on the line.  
     With the confidence bounds, \code{inputdataframe[,,1:4]} contains the x value, followed 
     by the y value for the line, then the low y value and finally the high y value.
   
   }

 } 
}

\note{A descriptor may be omitted if none of the panel plots need it.} 

\details{
   The panelDesc data.frame is used to describe the content of the micromapST plot to the function.
   It contains the index of the data in the \code{stateFrame} data.frame, the types of graphics to be used in
   each column, titles, column headers, reference values and labels, etc.
}

\author{Daniel B. Carr, George Mason University, Fairfax VA, with contributions from Jim Pearson and Linda Pickle of StatNet Consulting, LLC, Gaithersburg, MD}

\keyword{data structure}
\keyword{panelDesc}
\seealso{\code{\link{micromapST}}}
