\name{plotScores}
\alias{plotScores}
\alias{plotLoadings}

\title{
  Plotting scores and loadings in a \code{Panpca} object
}
\description{
  Creates informative plots for a principal component analysis of a pan-matrix.
}
\usage{
plotScores(pan.pca,x=1,y=2,show.labels=TRUE,labels=NULL,col="black",pch=16,...)
plotLoadings(pan.pca,x=1,y=2,show.labels=TRUE,col="black",pch=16,...)
}
\arguments{
  \item{pan.pca}{A \code{Panpca} object, see \code{\link{panpca}} for details.}
  \item{x}{The component to display along the horizontal axis.}
  \item{y}{The component to display along the vertical axis.}
  \item{show.labels}{Logical indicating if labels should be displayed.}
  \item{labels}{Alternative labels to use in the score-plot, see below.}
  \item{col}{Colors for the points/labels, see below.}
  \item{pch}{Marker type, see \code{\link{points}}.}
  \item{...}{Additional arguments passed on to \code{points} or \code{text} (if labels are specified).}
}
\details{
  A \code{Panpca} object contains the results of a principal component analysis on a pan-matrix, see \code{\link{panpca}} for details.
  
  The \code{\link{plotScores}} gives a visual overview of how the genomes are positioned relative to each other in the pan-genome space. The score-matrix of a \code{Panpca} has one row for each genome. The original pan-matrix also has one row for each genome. Two genomes can be compared by their corresponding rows in the pan-matrix, but can also be compared by their rows in the score-matrix, and the latter matrix has (much) fewer columns designed to contain maximum of the original data variation. A plot of the scores will give an approximate overview of how the genomes are located relative to each other.
  
  The \code{\link{plotLoadings}} gives a visual overview of how the gene clusters affect the principal components. The loadings is a matrix with one row for each of the original non-core gene clusters (core gene clusters have no variation across genomes). Clusters located close to the origin have little impact. Clusters far from the origin has high impact, indicating they separate groups of genomes.
  
  These two plots together can reveal information about the pan-genome: The score-plot shows if genomes are grouped/separated, and the loading-plot can then tell you which gene clusters have high impact on this grouping/separation.
  
  The arguments \samp{x} and \samp{y} can be used to plot other components than component 1 and 2 (which is always the most informative). In some cases more components are needed to establish a good picture, i.e. the explained variance is low for component 1 and 2 (see \code{\link{plot.Panpca}} for more on explained variance). It is quite common to plot component 1 versus 2, then 1 versus 3 and finally 2 versus 3.
  
  The argument \samp{show.labels} can be used to turn off the display of labels, only markers (dots) will appear.
  
  In \code{\link{plotScores}} you can specify alternative labels in \samp{labels}. By default, the GID-tag is used for each genome. You can supply a vector of alternative labels. The labels may be in any order, but the vector must be named by the GID-tags, i.e. each element in \samp{labels} must have a name which is a valid GID-tag for some genome. This is necessary to ensure the alternative labels are placed correctly in the score-space.
  
  There is no alternative labelling of loading-plots, since the gene clusters lack a GID-tag-like system. You can, however, change the gene cluster names by editing the column names of the pan-matrix directly before you do the \code{\link{panpca}}.
  
  You may color each label/marker individually. In \code{\link{plotScores}} you can again supply a vector of colors, and name every element with a GID-tag to make certain they are used correctly. In \code{\link{plotLoadings}} you can supply a vector of colors, but you must arrange them in proper order yourself.
  
  Additional arguments are passed on to \code{\link{text}} if \samp{show.labels=TRUE} and to \code{\link{points}} if \samp{show.labels=FALSE}.
}

\author{
  Lars Snipen and Kristian Hovde Liland.
}

\seealso{
  \code{\link{panpca}}, \code{\link{plot.Panpca}}.
}
\examples{
# Loading a Panmat object in the micropan package
data(list=c("Mpneumoniae.blast.panmat","Mpneumoniae.domain.panmat"),package="micropan")
ppca.blast <- panpca(Mpneumoniae.blast.panmat)

# Plotting scores and loadings
plotScores(ppca.blast) # A score-plot
plotLoadings(ppca.blast) # A loading plot

# Plotting score with alternative labels and colors
data(list="Mpneumoniae.table",package="micropan")
labels <- Mpneumoniae.table$Strain
names(labels) <- Mpneumoniae.table$GID.tag
cols <- Mpneumoniae.table$Color
names(cols) <- Mpneumoniae.table$GID.tag
plotScores(ppca.blast,labels=labels,col=cols)
}
