% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domainclust.R
\name{hmmerCleanOverlap}
\alias{hmmerCleanOverlap}
\title{Removing overlapping hits from HMMER3 scans}
\usage{
hmmerCleanOverlap(hmmer.tbl)
}
\arguments{
\item{hmmer.tbl}{A table (\code{tibble}) with \code{\link{hmmerScan}} results, see \code{\link{readHmmer}}.}
}
\value{
A \code{tibble} which is a subset of the input, where some rows may have been deleted to
avoid overlapping hits.
}
\description{
Removing hits to avoid overlapping HMMs on the same protein sequence.
}
\details{
When scanning sequences against a profile HMM database using \code{\link{hmmerScan}}, we
often find that several patterns (HMMs) match in the same region of the query sequence, i.e. we have
overlapping hits. The function \code{\link{hmmerCleanOverlap}} will remove the poorest overlapping hit
in a recursive way such that all overlaps are eliminated.

The input is a \code{tibble} of the type produced by \code{\link{readHmmer}}.
}
\examples{
# See the example in the Help-file for dClust.

}
\seealso{
\code{\link{hmmerScan}}, \code{\link{readHmmer}}, \code{\link{dClust}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
