% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plumber-add_service.R
\name{add_plumber_service}
\alias{add_plumber_service}
\title{Add a Service Route to the Microservice}
\usage{
add_plumber_service(path = ".", name, overwrite = FALSE)
}
\arguments{
\item{path}{(\code{character}) Where is the project root folder?}

\item{name}{(\code{character}) what is the service route name? For example, if
\code{name} = "repository" then the set of services would become available
at \verb{http://127.0.0.1:8080/repository/}.}

\item{overwrite}{(\code{logical}) Should existing destination files be overwritten?}
}
\value{
No return value, called for side effects.
}
\description{
Expose additional set of services on a separate URL.
}
\details{
Lay the infrastructure for an additional set of services. That includes
adding a unit test, adding an endpoint, and extending the entrypointy.\if{html}{\out{
<div class="alert alert-warning">
}}


\strong{Note:} \code{add_plumber_service} adds a service to pre-existing plumber
microservice which you could deploy by calling
\code{use_plumber_microservice}.\if{html}{\out{
</div>
}}

\subsection{How It Works}{

Given a \code{path} (“.”) to a folder and a \code{name} (“repository”)

When \code{add_plumber_service} is called

Then the function creates the following files:\if{html}{\out{<div class="r">}}\preformatted{tests/testthat/test-endpoint-plumber-repository.R
inst/endpoints/plumber-repository.R
}\if{html}{\out{</div>}}

And updates the following files:\if{html}{\out{<div class="r">}}\preformatted{inst/entrypoints/plumber-foreground.R
}\if{html}{\out{</div>}}
}

\subsection{When to Use}{

In scenarios where services are thematically linked to each other.
Examples for themes that should be mounted separately:
\itemize{
\item “forecasting” and “anomaly detection”
\item “user” and “business”
}
}
}
\examples{
path <- tempfile()
dir.create(path, showWarnings = FALSE, recursive = TRUE)
use_plumber_microservice(path)

add_plumber_service(path, name = "repository")

list.files(path, recursive = TRUE)
}
\seealso{
Other plumber microservice: 
\code{\link{use_plumber_microservice}()}
}
\concept{plumber microservice}
