% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expreg.R
\name{expreg}
\alias{expreg}
\title{Instrumental variable estimation for exponential conditional mean
models}
\usage{
expreg(
  formula,
  data,
  subset,
  weights,
  na.action,
  offset,
  method = c("iv", "gmm", "ls"),
  error = c("mult", "add"),
  ...
)
}
\arguments{
\item{formula}{a two-part right hand side formula, the first part
describing the covariates and the second part the instruments}

\item{data}{a data frame,}

\item{subset, weights, na.action, offset}{see \code{stats::lm}}

\item{method}{one of \code{"gmm"} (the default), \code{"iv"} or \code{ls}.}

\item{error}{one of \code{"mult"} (the default) or \code{"add"} in order to
get a model with respectively a multiplicative or an additive
error}

\item{...}{further arguments}
}
\value{
an object of class \code{"micsr"}, see \code{micsr::micsr} for further details.
}
\description{
Exponential conditional mean models are particularly useful for
non-negative responses (including count data). Least squares and one or two steps
IV estimators are available
}
\examples{
cigmales <- cigmales |>
            transform(age2 = age ^ 2, educ2 = educ ^ 2, educage = educ * age,
                      age3 = age ^ 3, educ3 = educ ^ 3)
expreg(cigarettes ~ habit + price + restaurant + income + age + age2 + educ + educ2 +
                     famsize + race | . - habit + reslgth + lagprice + age3 + educ3 + educage,
                     data = cigmales)
expreg(birthwt ~ cigarettes + parity + race + sex | parity + race + sex +
                  edmother + edfather + faminc + cigtax, data = birthwt)
}
\references{
\insertRef{MULL:97}{micsr}
}
\author{
Yves Croissant
}
\keyword{models}
