% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivprobit.R
\name{bivprobit}
\alias{bivprobit}
\alias{logLik.bivprobit}
\title{Bivariate probit}
\usage{
bivprobit(
  formula,
  data,
  weights,
  subset,
  na.action,
  offset,
  method = c("newton", "bfgs"),
  ...
)

\method{logLik}{bivprobit}(object, ..., type = c("model", "null"))
}
\arguments{
\item{formula}{a symbolic description of the model, a two-part left
and right hand side formula}

\item{data}{a data frame,}

\item{subset, weights, na.action, offset}{see \code{stats::lm},}

\item{method}{the optimization method, one of \code{"newton"} and
\code{"bfgs"}}

\item{...}{further arguments}

\item{object}{a \code{bivprobit} object}

\item{type}{for the \code{logLik} method}
}
\value{
an object of class \code{micsr}, see \code{micsr::micsr} for further
details
}
\description{
Estimation of bivariate probit models by maximum likelihood
}
\examples{
bivprobit(mjob | fjob ~ meduc + ychild + owner | feduc + ychild + owner , housprod)
}
\keyword{models}
