% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_sgl.R
\name{panel_sgl}
\alias{panel_sgl}
\title{Panel sg-LASSO regression model}
\usage{
panel_sgl(X, Z = NULL, y, index, entity_indices, gamma_w = NULL, l1_factor = NULL, 
  l21_factor = NULL, dummies_index = NULL, full_est = NULL, 
  regress_choice = c("re", "fe"), method_choice = c("ic", "cv", "initial"), 
  nlam = 100, lambdas = NULL, min_frac = NULL, nfolds = 10, 
  lambda_choice = c("min", "1se"), ic_choice = c("bic", "aic", "aicc"),
  num_cores = NULL, verbose = FALSE, thresh = NULL, 
  outer_thresh = NULL, inner_iter = NULL, outer_iter = NULL)
}
\arguments{
\item{X}{NT by p data matrix, where n, t and p respectively denote the number of individuals, sample size and the number of regressors.}

\item{Z}{dummies matrix for random effects or fixed effects panel data model. If left unspecified, it is computed based on \code{regress_choice} choice.}

\item{y}{NT by 1 vector of outcome.}

\item{index}{p by 1 vector indicating group membership of each covariate.}

\item{entity_indices}{NT by 1 vector of individual indices.}

\item{gamma_w}{sg-LASSO mixing parameter. \code{gamma_w = 1} is LASSO and \code{gamma_w = 0} group LASSO.}

\item{l1_factor}{\ifelse{html}{\out{&#8467;<sub>1</sub> norm penalty factor for random or fixed effects (default value is zero which means &alpha; is left unpenalized in &#8467;<sub>1</sub> norm).}}{\eqn{\ell_1} norm penalty factor for random or fixed effects (default value is zero which means \eqn{\alpha} is left unpenalized in \eqn{\ell_1} norm).}}

\item{l21_factor}{\ifelse{html}{\out{&#8467;<sub>2,1</sub> norm penalty factor for random or fixed effects (default value is zero which means &alpha; is left unpenalized in &#8467;<sub>2,1</sub> norm).}}{\eqn{\ell_1} norm penalty factor for random or fixed effects (default value is zero which means \eqn{\alpha} is left unpenalized in \eqn{\ell_1} norm).}}

\item{dummies_index}{vector indicating group membership of \eqn{\alpha} (default - no grouping).}

\item{full_est}{pre-estimated parameters based on full sample and \code{regress_choice} for a sequence of \eqn{\lambda}'s.}

\item{regress_choice}{choose between `re` and `fe`. `re` computes random effects regression with sg-LASSO penalty (default). `fe` computes fixed effects regression with sg-LASSO penalty.}

\item{method_choice}{choose between `initial`, `ic` and `cv`. `initial` pre-computes initial estimates. `ic` comptes solution based on information criteria (BIC, AIC or AICc). `cv` computes solution based on cross-validation (cv).}

\item{nlam}{number of \eqn{\lambda}'s to use in the regularization path.}

\item{lambdas}{user specified sequence of \eqn{\lambda} values for fitting. We recommend leaving this to NULL and letting function to self-select values.}

\item{min_frac}{the minimum value of the penalty parameter, as a fraction of the maximum value.}

\item{nfolds}{number of folds of the cv loop.}

\item{lambda_choice}{chose between `min` and `1se`. `min` computes solution that minimizes the cv error. `1se` computes solution such that the cv error is within 1 standard error of the minimum `min`.}

\item{ic_choice}{choose between `bic`, `aic` and `aicc`. `bic` computes solution that minimizes Bayesian information criterion. `aic` computes solution that minimizes Akaike information criterion. `aicc` omputes solution that minimizes Akaike information corrected criterion.}

\item{num_cores}{number of cores used to compute cv loop.}

\item{verbose}{flag to print information.}

\item{thresh}{convergence threshold for change in beta. We recommend leaving this to NULL.}

\item{outer_thresh}{outer loop convergence threshold. We recommend leaving this to NULL.}

\item{inner_iter}{the maximum number of inner sg-LASSO loop iterations. We recommend leaving this to NULL.}

\item{outer_iter}{the maximum number of outer sg-LASSO loop iterations. We recommend leaving this to NULL.}
}
\value{
Parameter estimates of panel data regression model under sg-LASSO penalty.
}
\description{
Fits panel data regression model, random and fixed effects, under sg-LASSO penalty function. Options include random effects and fixed effects models, cross-validation and information criteria for \eqn{\lambda} penalty parameter selection.
}
\details{
\ifelse{html}{\out{The sequence of panel data models implied by <code>lambdas</code> vector is fit by block coordinate-descent. The objective function is <br><br> <center> RSS(&alpha;,&beta;)/NT + 2&lambda;  &Omega;<sub>&gamma;</sub>(&beta;), </center> <br> where RSS(&alpha;,&beta;) is either random or fixed effects model fit. The penalty function &Omega;<sub>&gamma;</sub>(.) is applied on coefficients of time-varying covariates &beta; and is <br> <br> <center> &Omega;<sub>&gamma;</sub>(&beta;) = &gamma; |&beta;|<sub>1</sub> + (1-&gamma;)||&beta;||<sub>2,1</sub>, </center> <br> a convex combination of LASSO and group LASSO penalty functions. There are additional options to apply sg-LASSO structures on fixed effects coefficient vector &alpha; (see description of input variables for more details).}}{The sequence of panel data models implied by \code{lambdas} vector is fit by block coordinate-descent. The objective function is \deqn{RSS(\alpha,\beta)/NT + 2\lambda * \Omega_\gamma(\beta),} where \eqn{RSS(\alpha,\beta)} is either random or fixed effects model fit. The penalty function \eqn{\Omega_\gamma(.)} is applied on coefficients of time-varying covariates \eqn{\beta} and is \deqn{\Omega_\gamma(\beta) = \gamma |\beta|_1 + (1-\gamma)||\beta||_{2,1},} a convex combination of LASSO and group LASSO penalty functions. There are additional options to apply sg-LASSO structures on fixed effects coefficient vector \eqn{\alpha} (see description of input variables for more details).}
}
\examples{
\donttest{
# simulate DGP
set.seed(1)
t <- 21; n = 20; p = 100; size.groups = 4 
index <- ceiling(1:p / size.groups)
X <- matrix(rnorm(n * t * p), ncol = p, nrow = n*t)
beta <- c(5,4,3,2,1)
y <- X[,1:5] \%*\% beta + 5*rnorm(n*t)
entity_indices <- sort(rep(1:n,times=t-1))
panel_sgl(X = X, Z = NULL, y = y, index = index, 
  entity_indices = entity_indices, gamma_w = 1, 
  regress_choice = "fe", method_choice = "initial", 
  num_cores = 2, verbose = FALSE)
}
}
\author{
Jonas Striaukas
}
