% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{midas_dl}
\alias{midas_dl}
\title{DL-MIDAS regression}
\usage{
midas_dl(data.x, data.xdate, data.y, data.ydate, x.lag, est.start, est.end, horizon = 1,
  polynomial = c("legendre_w", "beta_w", "rbeta_w", "expalmon_w", "umidas_w", "step_fun"),
  scheme = c("fixed", "rolling", "expand"), loss = c("mse", "rq", "als"), ...)
}
\arguments{
\item{data.x}{predictor variable series.}

\item{data.xdate}{predictor variable dates.}

\item{data.y}{dependent variable series (can leave unspecified, see \code{midas_gen} option).}

\item{data.ydate}{dependent variable dates (can leave unspecified, see \code{midas_gen} option).}

\item{x.lag}{number of high-frequency data lags.}

\item{est.start}{start date of the estimation sample (referenced with data.xdate).}

\item{est.end}{end date of the estimation sample (referenced with data.xdate).}

\item{horizon}{forecast horizon measured in predictor variable sampling frequency (default set 1 unit ahead).}

\item{polynomial}{MIDAS lag polynomial specification. Options are: Legendre (\code{legendre_w}), Beta density (\code{beta_w}), restricted Beta density (\code{rbeta_w}), exponential Almon (\code{expalmon_w}), unrestricted MIDAS (\code{umidas_w}), step functions (\code{step_fun}).}

\item{scheme}{forecasting scheme. Options are: fixed scheme (fixed), rolling window scheme (rolling), expanding window scheme (expand).}

\item{loss}{loss function. Options are: mean squared error (mse), quantile (rq), asymmetric least squares (als).}

\item{...}{optional parameters to feed into other functions: \cr
\code{forecast.flag} - TRUE/FALSE to compute out-of-sample predictions (default TRUE) \cr
\code{disp.flag} - TRUE/FALSE  to display MIDAS data structures (default FALSE) \cr
\code{num.evals} - number of objective function evaluations using random starting parameter values in the case of non-linear MIDAS polynomial (default 1e4) \cr
\code{num.coef} - number of best coefficients to use as starting values in nonlinear optimization (default 10) \cr
\code{seed} - value used in set.seed for randomly drawing initial starting values around OLS optimal solution \cr
\code{profiling} - TRUE/FALSE to use MIDAS paramater profiling, coded only for rbeta_w polynomial, (default FALSE) \cr
\code{step_idx} - index of step function lags. If \code{step_fun} is used as a polynomial, it is best to specify this option too, otherwise, the program figures out the sampling frequency ratio and computes \code{step_idx} accordingly (message is displayed in this case) \cr
\code{legendre_degree} - a degree of legendre polynomials. If \code{legendre_w} is used as a polynomial, it is best to specify this option too, otherwise, the value is set to 3 (message is displayed in this case) \cr
\code{tau} - quantile level for als and rq regressions. If eithr als or rq loss is used, this option must be specified, program stops if no value is provided \cr
\code{midas_gen} - option on how to generate the low-frequency variable. \code{from_hf} - computes from high-frequency variable (see \code{mixed_freq_data_mhorizon}, \code{aggregation} method could be specified as an additional input) or \code{as_ref} - computes MIDAS data structures using low-frequency variable (default 'from_hf').}
}
\value{
returns \code{midas_dl} list which contains parameter estimates, in- and out-of-sample statistics and predictions, and some information about the specification of the method used.
}
\description{
Estimates and predicts using a single variate DL-MIDAS model.
}
\details{
\ifelse{html}{\out{Several polynomial functional forms are available (input variable <code>polynomial</code>): <br><br> - <code>beta_w</code>: Beta polynomial</center> <br> - <code>rbeta_w</code>: restricted Beta polynomial <br> - <code>expalmon_w</code>: exponential Almon polynomial <br>  - <code>umidas_w</code>: unrestricted lags (U-MIDAS) <br> - <code>step_fun</code>: polynomial with step functions <br> - <code>legendre_w</code>: Legendre polynomials <br> <br> different forecasting schemes (input variable <code>scheme</code>): <br><br>  - <code>fixed</code>: fixed scheme <br> - <code>rolling</code>: rolling window <br> - <code>expand</code>: expanding window <br><br> and different loss functions (input variable <code>loss</code>): <br><br> - <code>mse</code>: least squares <br> - <code>als</code>: asymmetric least squares <br> - <code>rq</code>: quantile. <br> <br> The DL-MIDAS model is: <br> <center> y<sub>t</sub> =  &mu; +  &beta;  &Sigma;<sub>j</sub> &omega;<sub>j</sub>(&theta;)x<sub>t-1</sub> </center> <br> where &mu;, &beta; and &theta; are model parameters and &omega; is the weight function.}}{Several polynomial functional forms are available (input variable \code{polynomial}): \cr  - \code{beta_w}: Beta polynomial \cr - \code{rbeta_w}: restricted Beta polynomial \cr - \code{expalmon_w}: Exp Almon polynomial \cr - \code{umidas_w}: unrestricted lags (U-MIDAS) \cr - \code{step_fun}: polynomial with step functions  \cr - \code{legendre_w}: Legendre polynomials \cr different forecasting schemes (input variable \code{scheme}): \cr - \code{fixed}: fixed scheme \cr - \code{rolling}: rolling window \cr - \code{expand}: expanding window \cr  and different loss functions (input variable \code{loss}) \cr - \code{mse}: least squares \cr - \code{als}: asymmetric least squares \cr - \code{rq}: quantile.  \cr\cr The DL-MIDAS model is: \cr \deqn{y_t =  \mu +  \beta  \sum_j \omega_j(\theta)x_{t-1}} \cr where \eqn{\mu}, \eqn{\beta} and \eqn{\theta} are model parameters and \eqn{\omega} is the weight function.}
}
\examples{
data(market_ret)
data.x <- market_ret$snp500ret
data.xdate <- market_ret$DATE
est.start <- as.Date("2005-01-01")
est.end <- as.Date("2017-12-31")
midas_dl(data.x, data.xdate, x.lag = 5, 
         est.start = est.start, est.end = est.end,
         horizon = 1, polynomial = "legendre_w", legendre_degree = 3,
         scheme = "fixed", loss = "mse", midas_gen = "from_hf")
}
\author{
Jonas Striaukas
}
