% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_sgl.R
\name{path_calc}
\alias{path_calc}
\title{Computes a sequence of lambda parameters for the mse sg-LASSO regression}
\usage{
path_calc(
  X,
  Z,
  y,
  index,
  gamma_w = NULL,
  l1_factor = 0,
  l21_factor = 0,
  dummies_index = 1,
  nlam = NULL,
  min_frac = NULL
)
}
\arguments{
\item{X}{T by p data matrix, where t and p respectively denote the sample size and the number of regressors.}

\item{Z}{dummies matrix left for the interecept.}

\item{y}{T by 1 vector of outcome.}

\item{index}{p by 1 vector indicating group membership of each covariate.}

\item{gamma_w}{sg-LASSO mixing parameter. \code{gamma_w = 1} is LASSO and \code{gamma_w = 0} group LASSO.}

\item{l1_factor}{penalty term on the intercept. Should be left unpenalized, i.e set to zero (default).}

\item{l21_factor}{penalty term on the intercept. Should be left unpenalized, i.e set to zero (default).}

\item{dummies_index}{vector indicating dummies group membership. Should be left unspecified, i.e set to one (default).}

\item{nlam}{number of \eqn{\lambda}'s to use in the regularization path.}

\item{min_frac}{the minimum value of the penalty parameter, as a fraction of the maximum value.}
}
\value{
lambdas sequence of \eqn{\lambda} values for fitting.
}
\description{
Computes a sequence of lambda parameters for the mse sg-LASSO regression
}
\keyword{internal}
