% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_sgl.R
\name{path_calc_panel}
\alias{path_calc_panel}
\title{Computes a sequence of lambda parameters for the sg-LASSO panel regression}
\usage{
path_calc_panel(
  X,
  Z,
  y,
  index,
  gamma_w = NULL,
  l1_factor = NULL,
  l21_factor = NULL,
  dummies_index = NULL,
  nlam = NULL,
  min_frac = NULL
)
}
\arguments{
\item{X}{nT by p data matrix, where n, t and p respectively denote the number of individuals, sample size and the number of regressors.}

\item{Z}{dummies matrix for random effects or fixed effects panel data model. If left unspecified, it is computed based on \code{regress_choice} choice.}

\item{y}{nT by 1 vector of outcome.}

\item{index}{p by 1 vector indicating group membership of each covariate.}

\item{gamma_w}{sg-LASSO mixing parameter. \code{gamma_w = 1} is LASSO and \code{gamma_w = 0} group LASSO.}

\item{l1_factor}{\eqn{\ell_1} norm peanlty factor for random or fixed effects (default value is zero which means \eqn{\alpha} is left unpenalized in \eqn{\ell_1} norm).}

\item{l21_factor}{\eqn{\ell_{1,2}} norm peanlty factor for random or fixed effects (default value is zero which means \eqn{\alpha} is left unpenalized in \eqn{\ell_{1,2}} norm).}

\item{dummies_index}{vector indicating group membership of \eqn{\alpha}.}

\item{nlam}{number of \eqn{\lambda}'s to use in the regularization path.}

\item{min_frac}{the minimum value of the penalty parameter, as a fraction of the maximum value.}
}
\value{
lambdas sequence of \eqn{\lambda} values for fitting.
}
\description{
Computes a sequence of lambda parameters for the sg-LASSO panel regression
}
\keyword{internal}
