% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{get_start_midas}
\alias{get_start_midas}
\title{MIDAS regression function for initial values}
\usage{
get_start_midas(
  y,
  X,
  z = NULL,
  loss = c("mse", "als", "rq"),
  weight,
  polynomial,
  num.evals = 1000,
  num.coef = 10,
  seed = NULL,
  tau = tau
)
}
\arguments{
\item{X}{predictor variable lags in MIDAS data format.}

\item{z}{autoregressive lags of response variable (default NULL, DL-MIDAS model is computed).}

\item{loss}{polynomial specification.}

\item{weight}{MIDAS weight function (depends on \code{polynomial}).}

\item{polynomial}{MIDAS polynomial specification.}

\item{num.evals}{number of objective function evaluations using random starting parameter values.}

\item{num.coef}{number of best coefficients to use as starting values in nonlinear optimization.}

\item{seed}{value used in set.seed for randomly drawing initial starting values.}

\item{tau}{quantile level for als and rq regressions.}

\item{params}{parameter vector from \code{midas_estimate}.}
}
\value{
returns \code{num.coef} number of initial parameter values.
}
\description{
Computes initial values for different MIDAS regression model specifications.
}
\details{
For a given loss function and MIDAS weight function specification, computes \code{num.evals} number of random initial values and evaluates the objective function at those parameters. 
 Function retains \code{num.coef} of best in terms of fit initial starting values, which are then feed into optimization algorithms.
}
\keyword{internal}
