% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.sglfit.R
\name{cv.sglfit}
\alias{cv.sglfit}
\title{Cross-validation fit for sg-LASSO}
\usage{
cv.sglfit(x, y, lambda = NULL, gamma = 1.0, gindex = 1:p, nfolds = 10, foldid, ...)
}
\arguments{
\item{x}{T by p data matrix, where t and p respectively denote the sample size and the number of regressors.}

\item{y}{T by 1 response variable.}

\item{lambda}{a user-supplied lambda sequence. By leaving this option unspecified (recommended), users can have the program compute its own \ifelse{html}{\out{&lambda;}}{\eqn{\lambda}} sequence based on \ifelse{html}{\out{<code>nlambda</code>}}{\code{nlambda}} and \ifelse{html}{\out{&gamma;}}{\eqn{\gamma}} \code{lambda.factor.} It is better to supply, if necessary, a decreasing sequence of lambda values than a single (small) value, as warm-starts are used in the optimization algorithm. The program will ensure that the user-supplied \code{lambda} sequence is sorted in decreasing order before fitting the model.}

\item{gamma}{sg-LASSO mixing parameter. \ifelse{html}{\out{&gamma;}}{\eqn{\gamma}} = 1 gives LASSO solution and \ifelse{html}{\out{&gamma;}}{\eqn{\gamma}} = 0 gives group LASSO solution.}

\item{gindex}{p by 1 vector indicating group membership of each covariate.}

\item{nfolds}{number of folds of the cv loop. Default set to \code{10}.}

\item{foldid}{the fold assignments used.}

\item{...}{Other arguments that can be passed to \code{sglfit}.}
}
\value{
cv.sglfit object.
}
\description{
Does k-fold cross-validation for sg-LASSO regression model.

The function runs \code{sglfit} \code{nfolds+1} times; the first to get the path solution in \ifelse{html}{\out{&lambda;}}{\eqn{\lambda}} sequence, the rest to compute the fit with each of the folds omitted. 
The average error and standard deviation over the folds is computed, and the optimal regression coefficients are returned for \code{lam.min} and \code{lam.1se}. Solutions are computed for a fixed \ifelse{html}{\out{&alpha;}}{\eqn{\alpha}.}
}
\details{
The cross-validation is run for sg-LASSO linear model. The sequence of linear regression models implied by \ifelse{html}{\out{&lambda;}}{\eqn{\lambda}} vector is fit by block coordinate-descent. The objective function is
\ifelse{html}{\out{<br><br> <center> RSS(&alpha;,&beta;)/T + 2&lambda;  &Omega;<sub>&gamma;</sub>(&beta;), </center> <br>}}{\deqn{RSS(\alpha,\beta)/T + 2\lambda * \Omega_\gamma(\beta),}} 
 where \ifelse{html}{\out{RSS(&alpha;,&beta;)}}{\eqn{RSS(\alpha,\beta)}} is the least squares fit. The penalty function \ifelse{html}{\out{&Omega;<sub>&gamma;</sub>(.)}}{\eqn{\Omega_\gamma(.)}} is applied on  \ifelse{html}{\out{&beta;}}{\eqn{\beta}} coefficients with the following structure 
 \ifelse{html}{\out{<br> <br> <center> &Omega;<sub>&gamma;</sub>(&beta;) = &gamma; |&beta;|<sub>1</sub> + (1-&gamma;)||&beta;||<sub>2,1</sub>. </center> <br>}}{\deqn{\Omega_\gamma(\beta) = \gamma |\beta|_1 + (1-\gamma)||\beta||_{2,1}.}} 
 The penalty is a convex combination of LASSO and group LASSO penalty functions. Tuning parameter \ifelse{html}{\out{&lambda;}}{\eqn{\lambda}} is chosen based on k-fold cross-validation and optimal solutions are returned for the minimum cvm (lam.min) or within 1 standard error of the minimum (lam.1se).
}
\examples{
\donttest{ 
set.seed(1)
x = matrix(rnorm(100 * 20), 100, 20)
beta = c(5,4,3,2,1,rep(0, times = 15))
y = x\%*\%beta + rnorm(100)
gindex = sort(rep(1:4,times=5))
cv.sglfit(x = x, y = y, gindex = gindex, gamma = 0.5)
}
}
\author{
Jonas Striaukas
}
