% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret.R
\name{interpret}
\alias{interpret}
\alias{interpret.default}
\alias{interpret.formula}
\title{Fit MID Models}
\usage{
interpret(object, ...)

\method{interpret}{default}(
  object,
  x,
  y = NULL,
  weights = NULL,
  pred.fun = get.yhat,
  link = NULL,
  k = c(NA, NA),
  type = c(1L, 1L),
  frames = list(),
  interaction = FALSE,
  terms = NULL,
  singular.ok = FALSE,
  mode = 1L,
  method = NULL,
  lambda = 0,
  kappa = 1e+06,
  na.action = getOption("na.action"),
  verbosity = 1L,
  encoding.digits = 3L,
  use.catchall = FALSE,
  catchall = "(others)",
  max.ncol = 10000L,
  nil = 1e-07,
  tol = 1e-07,
  pred.args = list(),
  ...
)

\method{interpret}{formula}(
  formula,
  data = NULL,
  model = NULL,
  pred.fun = get.yhat,
  weights = NULL,
  subset = NULL,
  na.action = getOption("na.action"),
  verbosity = 1L,
  mode = 1L,
  drop.unused.levels = FALSE,
  pred.args = list(),
  ...
)
}
\arguments{
\item{object}{a fitted model object to be interpreted.}

\item{...}{for \code{interpret.default()}, optional arguments can be provided, including \code{fit.intercept}, \code{interpolate.beta}, \code{weighted.norm}, and \code{weighted.encoding}. Special character aliases are also supported, such as \code{ok} for \code{singular.ok} and \code{ie} for \code{interaction}. For \code{interpret.formula()}, any arguments to be passed on to \code{interpret.default()}.}

\item{x}{a matrix or data.frame of predictor variables to be used in the fitting process. The response variable should not be included.}

\item{y}{an optional numeric vector of the model predictions or the response variable.}

\item{weights}{a numeric vector of sample weights for each observation in \code{x}.}

\item{pred.fun}{a function to obtain predictions from a fitted model, where the first argument is for the fitted model and the second argument is for new data. The default is \code{get.yhat()}.}

\item{link}{a character string specifying the link function: one of "logit", "probit", "cauchit", "cloglog", "identity", "log", "sqrt", "1/mu^2", "inverse", "translogit", "transprobit", "identity-logistic" and "identity-gaussian", or an object containing two functions \code{linkfun()} and \code{linkinv()}. See \code{help(make.link)}.}

\item{k}{an integer or integer-valued vector of length two. The maximum number of sample points for each variable. If a vector is passed, \code{k[1L]} is used for main effects and \code{k[2L]} is used for interactions. If an integer is passed, \code{k} is used for main effects and \code{sqrt(k)} is used for interactions. If not positive, all unique values are used as sample points.}

\item{type}{an integer or integer-valued vector of length two. The type of encoding. The effects of quantitative variables are modeled as piecewise linear functions if \code{type} is \code{1}, and as step functions if \code{type} is \code{0}. If a vector is passed, \code{type[1L]} is used for main effects and \code{type[2L]} is used for interactions.}

\item{frames}{a named list of encoding frames ("numeric.frame" or "factor.frame" objects). The encoding frames are used to encode the variable of the corresponding name. If the name begins with "|" or ":", the encoding frame is used only for main effects or interactions, respectively.}

\item{interaction}{logical. If \code{TRUE} and if \code{terms} and \code{formula} are not supplied, all interactions for each pair of variables are modeled and calculated.}

\item{terms}{a character vector of term labels specifying the set of component functions to be modeled. If not passed, \code{terms} includes all main effects, and all interactions if \code{interaction} is \code{TRUE}.}

\item{singular.ok}{logical. If \code{FALSE}, a singular fit is an error.}

\item{mode}{an integer specifying the method of calculation. If \code{mode} is \code{1}, the centralization constraints are treated as penalties for the least squares problem. If \code{mode} is \code{2}, the constraints are used to reduce the number of free parameters.}

\item{method}{an integer specifying the method to be used to solve the least squares problem. A non-negative value will be passed to \code{RcppEigen::fastLmPure()}. If negative, \code{stats::lm.fit()} is used.}

\item{lambda}{the penalty factor for pseudo smoothing. The default is \code{0}.}

\item{kappa}{the penalty factor for centering constraints. Used only when \code{mode} is \code{1}. The default is \code{1e+6}.}

\item{na.action}{a function or character string specifying the method of \code{NA} handling. The default is "na.omit".}

\item{verbosity}{the level of verbosity. \code{0}: fatal, \code{1}: warning (default), \code{2}: info or \code{3}: debug.}

\item{encoding.digits}{an integer. The rounding digits for encoding numeric variables. Used only when \code{type} is \code{1}.}

\item{use.catchall}{logical. If \code{TRUE}, less frequent levels of qualitative variables are dropped and replaced by the catchall level.}

\item{catchall}{a character string specifying the catchall level.}

\item{max.ncol}{integer. The maximum number of columns of the design matrix.}

\item{nil}{a threshold for the intercept and coefficients to be treated as zero. The default is \code{1e-7}.}

\item{tol}{a tolerance for the singular value decomposition. The default is \code{1e-7}.}

\item{pred.args}{optional parameters other than the fitted model and new data to be passed to \code{pred.fun()}.}

\item{formula}{a symbolic description of the MID model to be fit.}

\item{data}{a data.frame, list or environment containing the variables in \code{formula}. If not found in data, the variables are taken from \code{environment(formula)}.}

\item{model}{a fitted model object to be interpreted.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{drop.unused.levels}{logical. If \code{TRUE}, unused levels of factors will be dropped.}
}
\value{
\code{interpret()} returns a "mid" object with the following components:
\item{weights}{a numeric vector of the sample weights.}
\item{call}{the matched call.}
\item{terms}{the term labels.}
\item{link}{a "link-glm" or "link-midr" object containing the link function.}
\item{intercept}{the intercept.}
\item{encoders}{a list of variable encoders.}
\item{main.effects}{a list of data frames representing the main effects.}
\item{interacions}{a list of data frames representing the interactions.}
\item{ratio}{the ratio of the sum of squared error between the target model predictions and the fitted MID values, to the sum of squared deviations of the target model predictions.}
\item{fitted.matrix}{a matrix showing the breakdown of the predictions into the effects of the component functions.}
\item{linear.predictors}{a numeric vector of the linear predictors.}
\item{fitted.values}{a numeric vector of the fitted values.}
\item{residuals}{a numeric vector of the working residuals.}
\item{na.action}{information about the special handlings of \code{NA}s.}
}
\description{
\code{interpret()} is used to fit a MID model specifically as an interpretable surrogate for black-box predictive models.
A fitted MID model consists of a set of component functions, each with up to two variables.
}
\details{
\code{interpret()} returns a global surrogate model of the target predictive model.
The prediction function of this surrogate model is derived from Maximum Interpretation
Decomposition (MID) applied to the prediction function of the target model
(denoted \eqn{f(\mathbf{x})}).

The prediction function of the global surrogate model, denoted \eqn{\mathcal{F}(\mathbf{x})}, has the following structure:
\deqn{\mathcal{F}(\mathbf{x}) = f_\phi + \sum_{j} f_{j}(x_j) + \sum_{j<k} f_{jk}(x_j, x_k)}
where \eqn{f_\phi} is the intercept, \eqn{f_{j}(x_j)} is the main effect of feature \eqn{j},
and \eqn{f_{jk}(x_j, x_k)} is the second-order interaction effect between features \eqn{j} and \eqn{k}.

To ensure the identifiability (uniqueness) of these decomposed components, they are subject to centering constraints during the fitting process.
Specifically, each main effect function \eqn{f_j(x_j)} is constrained such that its average over the data distribution of feature \eqn{X_j} is zero.
Similarly, each second-order interaction effect function \eqn{f_{jk}(x_j, x_k)} is constrained such that its conditional average over \eqn{X_j} (for any fixed value \eqn{x_k}) is zero, and its conditional average over \eqn{X_k} (for any fixed value \eqn{x_j}) is also zero.

The surrogate model is fitted using the least squares method, which minimizes the squared error between the predictions of the target model \eqn{f(\mathbf{x})} and the surrogate model \eqn{\mathcal{F}(\mathbf{x})} (typically evaluated on a representative dataset).
}
\examples{
# fit a MID model as a surrogate model
data(cars, package = "datasets")
model <- lm(dist ~ I(speed^2) + speed, cars)
mid <- interpret(dist ~ speed, cars, model)
plot(mid, "speed", intercept = TRUE)
points(cars)

# customize the flexibility of a MID model
data(Nile, package = "datasets")
mid <- interpret(x = 1L:100L, y = Nile, k = 100L)
plot(mid, "x", intercept = TRUE, limits = c(600L, 1300L))
points(x = 1L:100L, y = Nile)
# reduce the number of knots by setting the 'k' parameter
mid <- interpret(x = 1L:100L, y = Nile, k = 10L)
plot(mid, "x", intercept = TRUE, limits = c(600L, 1300L))
points(x = 1L:100L, y = Nile)
# perform a pseudo smoothing by setting the 'lambda' parameter
mid <- interpret(x = 1L:100L, y = Nile, k = 100L, lambda = 100L)
plot(mid, "x", intercept = TRUE, limits = c(600L, 1300L))
points(x = 1L:100L, y = Nile)

# fit a MID model as a predictive model
data(airquality, package = "datasets")
mid <- interpret(Ozone ~ .^2, na.omit(airquality), lambda = .4)
plot(mid, "Wind")
plot(mid, "Temp")
plot(mid, "Wind:Temp", theme = "RdBu")
plot(mid, "Wind:Temp", main.effects = TRUE)
}
