% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mid_plots.R
\name{mid.plots}
\alias{mid.plots}
\title{Plot Multiple MID Component Functions}
\usage{
mid.plots(
  object,
  terms = mid.terms(object, interaction = FALSE),
  limits = c(NA, NA),
  intercept = FALSE,
  main.effects = FALSE,
  max.plots = NULL,
  engine = c("ggplot2", "graphics"),
  ...
)
}
\arguments{
\item{object}{a "mid" object.}

\item{terms}{a character vector. The names of the terms to be visualized.}

\item{limits}{\code{NULL} or a numeric vector of length two specifying the limits of the plotting scale. \code{NA}s are replaced by the minimum and/or maximum MID values.}

\item{intercept}{logical. If \code{TRUE}, the intercept is added to the MID values and the plotting scale is shifted.}

\item{main.effects}{logical. If \code{TRUE}, the main effects are included in the interaction plot.}

\item{max.plots}{an integer specifying the number of maximum number of plots.}

\item{engine}{character string. One of "ggplot2" or "graphics".}

\item{...}{optional parameters to be passed to \code{ggmid()} or \code{plot()}.}
}
\value{
If \code{engine} is "ggplot2", \code{mid.plots()} returns a list of "ggplot" objects. Otherwise \code{mid.plots()} produces plots and returns \code{NULL}.
}
\description{
\code{mid.plots()} applies \code{ggmid()} or \code{plot()} to the component functions of a "mid" object.
}
\examples{
data(diamonds, package = "ggplot2")
set.seed(42)
idx <- sample(nrow(diamonds), 1e4L)
mid <- interpret(price ~ (carat + cut + color + clarity) ^ 2, diamonds[idx, ])
mid.plots(mid, c("carat", "color", "carat:color", "clarity:color"), limits = NULL)
}
