% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mid_terms.R
\name{mid.terms}
\alias{mid.terms}
\title{Extract Terms from MID Models}
\usage{
mid.terms(
  object,
  main.effects = TRUE,
  interactions = TRUE,
  require = NULL,
  remove = NULL,
  ...
)
}
\arguments{
\item{object}{a "mid" object or another object that contains model terms. Can be a "mid.importance", "mid.conditional", or "mid.breakdown" object.}

\item{main.effects}{logical. If \code{FALSE}, the main effect terms are excluded.}

\item{interactions}{logical. If \code{FALSE}, the interactions terms are excluded.}

\item{require}{a character vector of variable names. Only terms related to at least one of these variables are returned.}

\item{remove}{a character vector of variable names. Terms related to any of these variables are excluded.}

\item{...}{aliases are supported for convenience: "me" for \code{main.effects} and "ie" for \code{interactions}.}
}
\value{
\code{mid.terms()} returns a character vector of the selected term labels.
}
\description{
\code{mid.terms()} extracts term labels from a fitted MID model or derivative objects.
Its primary strength is the ability to filter terms based on their type (main effects vs. interactions) or their associated variable names.
}
\details{
A "term" in a MID model refers to either a main effect (e.g., "Wind") or an interaction effect (e.g., "Wind:Temp").
This function provides a flexible way to select a subset of these terms, which is useful for plotting, summarizing, or other downstream analyses.
}
\note{
This function provides the common underlying logic for the \code{stats::terms()} S3 methods for "mid", "mid.importance", "mid.conditional", and "mid.breakdown" objects.
}
\examples{
data(airquality, package = "datasets")
mid <- interpret(Ozone ~ .^2, airquality, lambda = 1)

# Get only main effect terms
mid.terms(mid, interactions = FALSE)

# Get terms related to "Wind" or "Temp"
mid.terms(mid, require = c("Wind", "Temp"))

# Get terms related to "Wind" or "Temp", but exclude any with "Day"
mid.terms(mid, require = c("Wind", "Temp"), remove = "Day")

# Get the predicted contributions of only the terms associated with "Wind"
terms_wind <- mid.terms(mid, require = "Wind")
predict(mid, airquality[1:3,], terms = terms_wind, type = "terms")
}
\seealso{
\code{\link{interpret}}
}
