% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FiltorSurrogate.R
\name{FiltorSurrogate}
\alias{FiltorSurrogate}
\title{Abstract Surrogate Model Filtering Base Class}
\description{
Abstract base class for surrogate model filtering.

A \emph{surrogate model} is a regression model, based on an \code{\link[mlr3:Learner]{mlr3::Learner}}, which predicts the approximate performance of newly sampled configurations
given the empirical performance of already evaluated configurations. The surrogate model can be used to propose points that have, according to the
surrogate model, a relatively high chance of performing well.

The \code{FiltorSurrogate} base class can be inherited from to create different \code{\link{Filtor}}s that filter based on a surrogate model, for example tournament
filtering or progresive filtering.
}
\section{Configuration Parameters}{

\code{FiltorSurrogateProgressive}'s configuration parameters are the hyperparameters of the \code{surrogate_learner} \code{\link[mlr3:Learner]{Learner}}, as well as
the configuration parameters of the \code{surrogate_selector} \code{\link{Selector}}.
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Param]{Param}} classes depend on the supported feature types of the \code{surrogate_learner}, as reported
by \code{surrogate_learner$feature_types}: \code{"ParamInt"} requires
\code{"integer"}, \code{"ParamDbl"} requires \code{"numeric"}, \code{"ParamLgl"} requires \code{"logical"}, and \code{"ParamFct"} requires \code{"factor"}.
}

\seealso{
Other base classes: 
\code{\link{Filtor}},
\code{\link{MiesOperator}},
\code{\link{MutatorDiscrete}},
\code{\link{MutatorNumeric}},
\code{\link{Mutator}},
\code{\link{OperatorCombination}},
\code{\link{RecombinatorPair}},
\code{\link{Recombinator}},
\code{\link{Scalor}},
\code{\link{SelectorScalar}},
\code{\link{Selector}}

Other filtors: 
\code{\link{Filtor}},
\code{\link{dict_filtors_maybe}},
\code{\link{dict_filtors_null}},
\code{\link{dict_filtors_proxy}},
\code{\link{dict_filtors_surprog}},
\code{\link{dict_filtors_surtour}}
}
\concept{base classes}
\concept{filtors}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Filtor]{miesmuschel::Filtor}} -> \code{FiltorSurrogate}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{surrogate_learner}}{(\code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}})\cr
Regression learner for the surrogate model filtering algorithm.}

\item{\code{surrogate_selector}}{(\code{\link{Selector}})\cr
\code{\link{Selector}} with which to select using surrogate-predicted performance}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FiltorSurrogate-new}{\code{FiltorSurrogate$new()}}
\item \href{#method-FiltorSurrogate-prime}{\code{FiltorSurrogate$prime()}}
\item \href{#method-FiltorSurrogate-clone}{\code{FiltorSurrogate$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="Filtor" data-id="needed_input"><a href='../../miesmuschel/html/Filtor.html#method-Filtor-needed_input'><code>miesmuschel::Filtor$needed_input()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FiltorSurrogate-new"></a>}}
\if{latex}{\out{\hypertarget{method-FiltorSurrogate-new}{}}}
\subsection{Method \code{new()}}{
Initialize the base class components of the \code{FiltorSurrogate}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FiltorSurrogate$new(
  surrogate_learner,
  surrogate_selector = SelectorBest$new(),
  param_set = ps(),
  packages = character(0),
  dict_entry = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{surrogate_learner}}{(\code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}})\cr
Regression learner for the surrogate model filtering algorithm.\cr
The \verb{$surrogate_learner} field will reflect this value.}

\item{\code{surrogate_learner}}{(\code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}})\cr
Regression learner for the surrogate model filtering algorithm.\cr
The \verb{$surrogate_learner} field will reflect this value.}

\item{\code{surrogate_selector}}{(\code{\link{Selector}})
\code{\link{Selector}} for the surrogate model filtering algorithm.\cr
The \verb{$surrogate_selector} field will reflect this value.}

\item{\code{surrogate_selector}}{(\code{\link{Selector}})
\code{\link{Selector}} for the surrogate model filtering algorithm.\cr
The \verb{$surrogate_selector} field will reflect this value.}

\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
\code{\link[paradox:ParamSet]{ParamSet}} of the method implemented in the inheriting class with configuration parameters that go beyond the
parameters of the \code{surrogate_learner} and \code{surrogate_selector}.}

\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}} | \code{list} of \code{expression})\cr
Strategy parameters of the operator. This should be created by the subclass and given to \code{super$initialize()}.
If this is a \code{\link[paradox:ParamSet]{ParamSet}}, it is used as the \code{MiesOperator}'s \code{\link[paradox:ParamSet]{ParamSet}}
directly. Otherwise it must be a \code{list} of expressions e.g. created by \code{alist()} that evaluate to \code{\link[paradox:ParamSet]{ParamSet}}s,
possibly referencing \code{self} and \code{private}.
These \code{\link[paradox:ParamSet]{ParamSet}} are then combined using a \code{\link[paradox:ParamSetCollection]{ParamSetCollection}}.
Default is the empty \code{\link[paradox:ParamSet]{ParamSet}}.\cr
The \verb{$param_set} field will reflect this value.}

\item{\code{packages}}{(\code{character})
Packages that need to be loaded for the operator to function. This should
be declared so these packages can be loaded when operators run on parallel
instances. Default is \code{character(0)}.\cr
The \verb{$packages} field will reflect this values.}

\item{\code{packages}}{(\code{character})
Packages that need to be loaded for the operator to function. This should
be declared so these packages can be loaded when operators run on parallel
instances. Default is \code{character(0)}.\cr
The \verb{$packages} field will reflect this values.}

\item{\code{dict_entry}}{(\code{character(1)} | \code{NULL})\cr
Key of the class inside the \code{\link[mlr3misc:Dictionary]{Dictionary}} (usually one of
\code{\link{dict_mutators}}, \code{\link{dict_recombinators}}, \code{\link{dict_selectors}}), where it can
be retrieved using a \link[=mut]{short access function}. May be \code{NULL} if the operator
is not entered in a dictionary.\cr
The \verb{$dict_entry} field will reflect this value.}

\item{\code{dict_entry}}{(\code{character(1)} | \code{NULL})\cr
Key of the class inside the \code{\link[mlr3misc:Dictionary]{Dictionary}} (usually one of
\code{\link{dict_mutators}}, \code{\link{dict_recombinators}}, \code{\link{dict_selectors}}), where it can
be retrieved using a \link[=mut]{short access function}. May be \code{NULL} if the operator
is not entered in a dictionary.\cr
The \verb{$dict_entry} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FiltorSurrogate-prime"></a>}}
\if{latex}{\out{\hypertarget{method-FiltorSurrogate-prime}{}}}
\subsection{Method \code{prime()}}{
See \code{\link{MiesOperator}} method. Primes both this operator, as well as the wrapped operator
given to \code{surrogate_selector} during construction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FiltorSurrogate$prime(param_set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Passed to \code{\link{MiesOperator}}\verb{$prime()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FiltorSurrogate-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FiltorSurrogate-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FiltorSurrogate$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
