% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecombinatorCmpMaybe.R
\name{dict_recombinators_cmpmaybe}
\alias{dict_recombinators_cmpmaybe}
\alias{RecombinatorCmpMaybe}
\title{Recombinator Choosing Action Component-Wise Independently}
\description{
\code{\link{Recombinator}} that chooses which operation to perform probabilistically and independently for each component.
The \code{\link{Recombinator}} wraps two other \code{\link{Recombinator}}s given during construction,
and both of these operators are run. The ultimate result is sampled from the results of these operations independently for each individuum
and component: with probability \code{p} (configuration parameter), the result from the \code{\link{Recombinator}} given to
the \code{recombinator} construction argument is used, and with probability \code{p - 1} the one given to \code{recombinator_not} is used.

The values of \verb{$n_indivs_in} and \verb{$n_indivs_out} is set to the corresponding values of the wrapped \code{\link{Recombinator}}s. Both \code{recombinator} and \code{recombinator_not}
must currently have the same respective \verb{$n_indivs_in} and \verb{$n_indivs_out} values.
}
\section{Configuration Parameters}{

This operator has the configuration parameters of the \code{\link{Recombinator}}s that it wraps: The configuration parameters of the operator given to the \code{recombinator} construction argument
are prefixed with \code{"cmpmaybe."}, the configuration parameters of the operator given to the \code{recombinator_not} construction argument are prefixed with \code{"cmpmaybe_not."}.

Additional configuration parameters:
\itemize{
\item \code{p} :: \code{numeric(1)} \cr
Probability per component with which to use the result of applying the operator given to the \code{recombinator} construction argument. Must be set by the user.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Param]{Param}} classes are the set intersection of supported classes of \code{recombinator} and \code{recombinator_not}.
}

\section{Dictionary}{

This \code{\link{Recombinator}} can be created with the short access form \code{\link[=rec]{rec()}}
(\code{\link[=recs]{recs()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_recombinators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
rec("cmpmaybe", <recombinator> [, <recombinator_not>])
recs("cmpmaybe", <recombinator> [, <recombinator_not>])  # takes vector IDs, returns list of Recombinators

# long form:
dict_recombinators$get("cmpmaybe", <recombinator> [, <recombinator_not>])
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)
rm = rec("cmpmaybe", rec("swap"), p = 0.5)
p = ps(x = p_int(1, 8), y = p_dbl(1, 8), z = p_lgl())
data = data.frame(x = 1:8, y = 1:8, z = rep(TRUE, 4))

rm$prime(p)
rm$operate(data)

rm$param_set$values$p = 0.3
rm$operate(data)

# equivalent to rec("cmpmaybe", rec("swap", keep_complement = FALSE), p = 0.7)
rm2 = rec("cmpmaybe",
  recombinator = rec("null", 2, 1),
  recombinator_not = rec("swap", keep_complement = FALSE),
  p = 0.3
)

rm2$prime(p)
rm2$operate(data)
}
\seealso{
Other recombinators: 
\code{\link{OperatorCombination}},
\code{\link{RecombinatorPair}},
\code{\link{Recombinator}},
\code{\link{dict_recombinators_convex}},
\code{\link{dict_recombinators_cvxpair}},
\code{\link{dict_recombinators_maybe}},
\code{\link{dict_recombinators_null}},
\code{\link{dict_recombinators_proxy}},
\code{\link{dict_recombinators_sbx}},
\code{\link{dict_recombinators_sequential}},
\code{\link{dict_recombinators_swap}},
\code{\link{dict_recombinators_xonary}},
\code{\link{dict_recombinators_xounif}}

Other recombinator wrappers: 
\code{\link{OperatorCombination}},
\code{\link{dict_recombinators_maybe}},
\code{\link{dict_recombinators_proxy}},
\code{\link{dict_recombinators_sequential}}
}
\concept{recombinator wrappers}
\concept{recombinators}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Recombinator]{miesmuschel::Recombinator}} -> \code{RecombinatorCmpMaybe}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{recombinator}}{(\code{\link{Recombinator}})\cr
\code{\link{Recombinator}} being wrapped. This operator gets run with probability \code{p} (configuration parameter).}

\item{\code{recombinator_not}}{(\code{\link{Recombinator}})\cr
Alternative \code{\link{Recombinator}} being wrapped. This operator gets run with probability \code{1 - p} (configuration parameter).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RecombinatorCmpMaybe-new}{\code{RecombinatorCmpMaybe$new()}}
\item \href{#method-RecombinatorCmpMaybe-prime}{\code{RecombinatorCmpMaybe$prime()}}
\item \href{#method-RecombinatorCmpMaybe-clone}{\code{RecombinatorCmpMaybe$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorCmpMaybe-new"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorCmpMaybe-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{RecombinatorCmpMaybe} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorCmpMaybe$new(recombinator, recombinator_not = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{recombinator}}{(\code{\link{Recombinator}})\cr
\code{\link{Recombinator}} to wrap. Component-wise results of this operator are used with probability \code{p} (Configuration parameter).\cr
The constructed object gets a \emph{clone} of this argument.
The \verb{$recombinator} field will reflect this value.}

\item{\code{recombinator_not}}{(\code{\link{Recombinator}})\cr
Another \code{\link{Recombinator}} to wrap. Results from this operator are used when \code{recombinator} is not chosen. By
default, this is \code{\link{RecombinatorNull}}, i.e. no operation, with both \code{n_indivs_in} and \code{n_indivs_out} set
to match \code{recombinator}. This does not work when \code{recombinator} has \code{n_indivs_in < n_indivs_out}, in which
case this argument must be set explicitly.\cr
With this default, the \code{RecombinatorCmpMaybe} object applies the \code{recombinator} operation with probability \code{p}, and
no operation at all otherwise.\cr
The constructed object gets a \emph{clone} of this argument.
The \verb{$recombinator_not} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorCmpMaybe-prime"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorCmpMaybe-prime}{}}}
\subsection{Method \code{prime()}}{
See \code{\link{MiesOperator}} method. Primes both this operator, as well as the wrapped operators
given to \code{recombinator} and \code{recombinator_not} during construction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorCmpMaybe$prime(param_set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Passed to \code{\link{MiesOperator}}\verb{$prime()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorCmpMaybe-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorCmpMaybe-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorCmpMaybe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
