% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecombinatorCrossoverNary.R
\name{dict_recombinators_xonary}
\alias{dict_recombinators_xonary}
\alias{RecombinatorCrossoverNary}
\title{N-ary Crossover Recombinator}
\description{
Values are chosen componentwise independently at random from multiple individuals.
The number of individuals must be determined during construction as \code{n_indivs_in}.

The number of output individuals is always 1, i.e. \code{n_indivs_in} are used to create one output value. When using this
recombinator in a typical EA setting, e.g. with \code{\link{mies_generate_offspring}}, it is therefore recommended to use a parent-selector
where the expected quality of selected parents does not depend on the number of parents selected when \code{n_indivs_in} is large:
\code{\link[=SelectorTournament]{sel("tournament")}} is preferred to \code{\link[=SelectorBest]{sel("best")}}.
}
\section{Configuration Parameters}{

\itemize{
\item \code{p} :: \code{numeric} | \code{matrix}\cr
Sampling weights these are normalized to sum to 1 internally. Must either be a vector of length \code{n_indivs_in}, or a matrix with
\code{n_indivs_in} rows and as many columns as there
are components in the values being operated on. Must be non-negative, at least one value per column must be greater than zero, but it is not
necessary that they sum to 1.\cr
Initialized to \code{rep(1, n_indivs_in)}, i.e. uniform sampling from all individuals being operated on.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Domain]{Domain}} classes are: \code{\link[paradox:Domain]{p_dbl}} ('ParamDbl')
}

\section{Dictionary}{

This \code{\link{Recombinator}} can be created with the short access form \code{\link[=rec]{rec()}}
(\code{\link[=recs]{recs()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_recombinators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
rec("convex")
recs("convex")  # takes vector IDs, returns list of Recombinators

# long form:
dict_recombinators$get("convex")
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)
rxon = rec("xonary", n_indivs_in = 3)
p = ps(x = p_dbl(-5, 5), y = p_dbl(-5, 5), z = p_dbl(-5, 5))
data = data.frame(x = 0:5, y = 0:5, z = 0:5)

rxon$prime(p)
rxon$operate(data)  # uniform sampling from groups of 3

rxon = rec("xonary", 3, p = c(0, 1, 2))$prime(p)
# for groups of 3, take with probability 1/3 from 2nd and with probability 2/3 from 3rd row
rxon$operate(data)

pmat = matrix(c(0, 1, 2, 1, 1, 1, 1, 0, 0), ncol = 3)
pmat

rxon = rec("xonary", 3, p = pmat)$prime(p)
rxon$operate(data)  # componentwise different operation

}
\seealso{
Other recombinators: 
\code{\link{OperatorCombination}},
\code{\link{Recombinator}},
\code{\link{RecombinatorPair}},
\code{\link{dict_recombinators_cmpmaybe}},
\code{\link{dict_recombinators_convex}},
\code{\link{dict_recombinators_cvxpair}},
\code{\link{dict_recombinators_maybe}},
\code{\link{dict_recombinators_null}},
\code{\link{dict_recombinators_proxy}},
\code{\link{dict_recombinators_sbx}},
\code{\link{dict_recombinators_sequential}},
\code{\link{dict_recombinators_swap}},
\code{\link{dict_recombinators_xounif}}
}
\concept{recombinators}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Recombinator]{miesmuschel::Recombinator}} -> \code{RecombinatorCrossoverNary}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RecombinatorCrossoverNary-new}{\code{RecombinatorCrossoverNary$new()}}
\item \href{#method-RecombinatorCrossoverNary-clone}{\code{RecombinatorCrossoverNary$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="prime"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-prime'><code>miesmuschel::MiesOperator$prime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorCrossoverNary-new"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorCrossoverNary-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{RecombinatorConvex} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorCrossoverNary$new(n_indivs_in = 2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_indivs_in}}{(\code{integer(1)})\cr
Number of individuals to consider at the same time. When operating, the number of input individuals must be divisible by this number.
Default 2.\cr
The \verb{$n_indivs_in} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorCrossoverNary-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorCrossoverNary-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorCrossoverNary$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
