% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScalorHypervolume.R
\name{dict_scalors_hypervolume}
\alias{dict_scalors_hypervolume}
\alias{ScalorHypervolume}
\title{Hypervolume Scalor}
\description{
\code{\link{Scalor}} that returns the hypervolume of each individual, relative to \code{nadir} and as a contribution over \code{baseline}.
The returned scalar value is the measure of all points that have fitnesses that are
\itemize{
\item greater than the respective value in \code{nadir} in all dimensions, and
\item smaller than the respective value in the given point in all dimensions, and
\item greater than all points in \code{baseline} in at least one dimension.
}

\code{baseline} should probably be a \code{paradox::ContextPV} and generate fitness values from the \code{\link[bbotk:Archive]{Archive}}
in the context using \code{\link{mies_get_fitnesses}}.
}
\section{Configuration Parameters}{

\itemize{
\item \code{scale_output} :: \code{logical(1)}\cr
Whether to scale output to lie between 0 and 1.
\item \code{nadir} :: \code{numeric}\cr
Nadir of fitness values relative to which hypervolume ution is calculated.
\item \code{baseline} :: \code{matrix}\cr
Fitness-matrix with one column per objective, giving a population over which the hypervolume improvement should be calculated.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Domain]{Domain}} classes are: \code{\link[paradox:Domain]{p_lgl}} ('ParamLgl'), \code{\link[paradox:Domain]{p_int}} ('ParamInt'), \code{\link[paradox:Domain]{p_dbl}} ('ParamDbl'), \code{\link[paradox:Domain]{p_fct}} ('ParamFct')
}

\section{Dictionary}{

This \code{\link{Scalor}} can be created with the short access form \code{\link[=scl]{scl()}}
(\code{\link[=scls]{scls()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_scalors}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
scl("hypervolume")
scls("hypervolume")  # takes vector IDs, returns list of Scalors

# long form:
dict_scalors$get("hypervolume")
}\if{html}{\out{</div>}}
}

\examples{
sv = scl("hypervolume")
p = ps(x = p_dbl(-5, 5))
# dummy data; note that ScalorHV does not depend on data content
data = data.frame(x = rep(0, 5))
fitnesses = matrix(c(1, 5, 2, 3, 0, 3, 1, 0, 10, 8), ncol = 2)
sv$param_set$values$baseline = matrix(c(1, 1), ncol = 2)
sv$param_set$values$nadir = c(0, -1)

sv$prime(p)

sv$operate(data, fitnesses)
}
\seealso{
Other scalors: 
\code{\link{Scalor}},
\code{\link{dict_scalors_aggregate}},
\code{\link{dict_scalors_domcount}},
\code{\link{dict_scalors_fixedprojection}},
\code{\link{dict_scalors_nondom}},
\code{\link{dict_scalors_one}},
\code{\link{dict_scalors_proxy}},
\code{\link{dict_scalors_single}}
}
\concept{scalors}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Scalor]{miesmuschel::Scalor}} -> \code{ScalorHypervolume}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ScalorHypervolume-new}{\code{ScalorHypervolume$new()}}
\item \href{#method-ScalorHypervolume-clone}{\code{ScalorHypervolume$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="prime"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-prime'><code>miesmuschel::MiesOperator$prime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScalorHypervolume-new"></a>}}
\if{latex}{\out{\hypertarget{method-ScalorHypervolume-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{ScalorHypervolume} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalorHypervolume$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ScalorHypervolume-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ScalorHypervolume-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalorHypervolume$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
