% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale_net.R
\name{rescale_net}
\alias{rescale_net}
\title{Rescale net migration total to a global zero sum}
\usage{
rescale_net(
  x,
  method = "no-switches",
  w = rep(1, length(x)),
  integer_result = TRUE
)
}
\arguments{
\item{x}{Vector of net migration values}

\item{method}{Method used to adjust net migration values of \code{x} to obtain a global zero sum. By default \code{method="no-switches"}. Can also take values \code{method="switches"}. See details for explanation on each method.}

\item{w}{Weights used in rescaling method}

\item{integer_result}{Logical operator to indicate if output should be integers, default is \code{TRUE}.}
}
\value{
Rescales net migration for a number of regions in vector \code{x} to sum to zero.  When \code{method="no-switches"} rescaling of values are done for the positive and negative values separately, to ensure the final global sum is zero. When \code{method="switches"} the mean of the unscaled net migration is subtracted from each value.
}
\description{
Modify a set of net migration (or any numbers) so that they sum to zero.
}
\examples{
# net migration in regions countries (does not add up to zero)
x <- c(-200, -30, -5, 0, 10, 20, 60, 80)
x
sum(x)
# rescale 
y1 <- rescale_net(x)
y1
sum(y1)
# rescale without integer restriction
y2 <- rescale_net(x, integer_result = FALSE)
y2
sum(y2)
# rescale allowing switching of signs (small negative value becomes positive)
y3 <- rescale_net(x, method = "switches")
y3
sum(y3)
}
\references{
Abel, G. J. (2018). Non-zero trajectories for long-run net migration assumptions in global population projection models. \emph{Demographic Research} 38, (54) 1635–1662
}
\author{
Guy J. Abel
}
