% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_census.R
\name{graph_census}
\alias{graph_census}
\alias{graph_dyad_census}
\alias{graph_triad_census}
\alias{graph_mixed_census}
\title{Censuses of graphs' motifs}
\source{
Alejandro Espinosa 'netmem'
}
\usage{
graph_dyad_census(object)

graph_triad_census(object)

graph_mixed_census(object, object2)
}
\arguments{
\item{object}{A migraph-consistent object.}

\item{object2}{A second, two-mode migraph-consistent object.}
}
\description{
Censuses of graphs' motifs
}
\section{Functions}{
\itemize{
\item \code{graph_dyad_census}: Returns a census of dyad motifs in a network

\item \code{graph_triad_census}: Returns a census of triad motifs in a network

\item \code{graph_mixed_census}: Returns a census of triad motifs that span
a one-mode and a two-mode network
}}

\examples{
graph_dyad_census(ison_adolescents)
graph_triad_census(ison_adolescents)
marvel_friends <- to_unsigned(ison_marvel_relationships, "positive")
(mixed_cen <- graph_mixed_census(marvel_friends, ison_marvel_teams))
}
\references{
Davis, James A., and Samuel Leinhardt. 1967.
“\href{https://files.eric.ed.gov/fulltext/ED024086.pdf}{The Structure of Positive Interpersonal Relations in Small Groups}.” 55.

Hollway, James, Alessandro Lomi, Francesca Pallotti, and Christoph Stadtfeld. 2017.
“Multilevel Social Spaces: The Network Dynamics of Organizational Fields.”
\emph{Network Science} 5(2): 187–212.
\doi{10.1017/nws.2017.8}
}
\seealso{
Other motifs: 
\code{\link{node_census}}
}
\concept{motifs}
