% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_centrality.R
\name{centralisation}
\alias{centralisation}
\alias{graph_degree}
\alias{graph_closeness}
\alias{graph_betweenness}
\alias{graph_eigenvector}
\title{Measures of network centralisation}
\usage{
graph_degree(object, normalized = TRUE, direction = c("all", "out", "in"))

graph_closeness(object, normalized = TRUE, direction = c("all", "out", "in"))

graph_betweenness(object, normalized = TRUE, direction = c("all", "out", "in"))

graph_eigenvector(object, normalized = TRUE)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{normalized}{Logical scalar, whether the centrality scores are normalized.
Different denominators are used depending on whether the object is one-mode or two-mode,
the type of centrality, and other arguments.}

\item{direction}{Character string, “out” bases the measure on outgoing ties,
“in” on incoming ties, and "all" on either/the sum of the two.
For two-mode networks, "all" uses as numerator the sum of differences
between the maximum centrality score for the mode
against all other centrality scores in the network,
whereas "in" uses as numerator the sum of differences
between the maximum centrality score for the mode
against only the centrality scores of the other nodes in that mode.}
}
\description{
Measures of network centralisation
}
\section{Functions}{
\itemize{
\item \code{graph_degree()}: Calculate the degree centralization for a graph

\item \code{graph_closeness()}: Calculate the closeness centralization for a graph

\item \code{graph_betweenness()}: Calculate the betweenness centralization for a graph

\item \code{graph_eigenvector()}: Calculate the eigenvector centralization for a graph

}}
\examples{
graph_degree(ison_southern_women, direction = "in")
graph_closeness(ison_southern_women, direction = "in")
graph_betweenness(ison_southern_women, direction = "in")
graph_eigenvector(mpn_elite_mex)
graph_eigenvector(ison_southern_women)
}
\seealso{
Other measures: 
\code{\link{centrality}},
\code{\link{closure}},
\code{\link{cohesion}()},
\code{\link{diversity}},
\code{\link{features}},
\code{\link{holes}}
}
\concept{measures}
