% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_matrix.R
\name{build_matrix}
\alias{build_matrix}
\title{Build a migration (transition) matrix}
\usage{
build_matrix(data, state_start = NULL, state_end = NULL, metric = NULL)
}
\arguments{
\item{data}{A data frame or data frame extension (e.g., a tibble or
data.table) containing a minimum of three (3) column variables representing
a starting credit risk state, an ending credit risk state, and a metric
containing values representing the movement (i.e., "transition) in that
metric between the starting credit risk state point in time and the ending
credit risk state point in time. This style of data frame is output by the
`migrate()` function within this package.}

\item{state_start}{(Optional) A symbol or string, representing the column
variable of the `data` data frame argument that contains the starting
credit risk state values. If left null, function will attempt to find it
for you.}

\item{state_end}{(Optional) A symbol or string, representing the column
variable of the `data` data frame argument that contains the starting
credit risk state values. If left null, function will attempt to find it
for you.}

\item{metric}{(Optional) A symbol or string, representing the column variable
of the `data` data frame argument that contains the metric for which the
grouped difference in value between the starting credit risk state period
and ending credit risk state period was computed.}
}
\value{
A matrix object, where the first (row) dimension represents the starting
credit risk state, the second (column) dimension represents the ending credit
risk state, and the values within the matrix represent the transitioned
amount based upon the values in the `metric` continuous column variable from
the `data` data frame.

Note: A matrix object can be coerced to a data frame using `as.data.frame()`.
}
\description{
`build_matrix()` creates a credit migration (i.e., "transition") matrix from
  summarized data representing each credit risk state & a continuous metric
  at two distinct points in time.
}
\examples{
# Let `build_matrix()` guess which column variables represent `state_start`,
# `state_end` and `metric`
mock_credit \%>\%
  migrate(
    time = date,
    state = risk_rating,
    id = customer_id,
    metric = principal_balance
  ) \%>\%
  build_matrix()

# Specify which column variables represent `state_start`, `state_end` and
# `metric`
mock_credit \%>\%
  migrate(
    id = customer_id,
    time = date,
    state = risk_rating,
    percent = FALSE
  ) \%>\%
  build_matrix(
    state_start = risk_rating_start,
    state_end = risk_rating_end,
    metric = count
  )
}
