% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_importance.R
\name{get_feature_importance}
\alias{get_feature_importance}
\title{Get feature importance using the permutation method}
\usage{
get_feature_importance(
  trained_model,
  train_data,
  test_data,
  outcome_colname,
  perf_metric_function,
  perf_metric_name,
  class_probs,
  method,
  seed = NA,
  corr_thresh = 1,
  groups = NULL,
  nperms = 100,
  corr_method = "spearman"
)
}
\arguments{
\item{trained_model}{Trained model from \code{\link[caret:train]{caret::train()}}.}

\item{train_data}{Training data: dataframe of outcome and features.}

\item{test_data}{Held out test data: dataframe of outcome and features.}

\item{outcome_colname}{Column name as a string of the outcome variable
(default \code{NULL}; the first column will be chosen automatically).}

\item{perf_metric_function}{Function to calculate the performance metric to
be used for cross-validation and test performance. Some functions are
provided by caret (see \code{\link[caret:postResample]{caret::defaultSummary()}}).
Defaults: binary classification = \code{twoClassSummary},
multi-class classification = \code{multiClassSummary},
regression = \code{defaultSummary}.}

\item{perf_metric_name}{The column name from the output of the function
provided to perf_metric_function that is to be used as the performance metric.
Defaults: binary classification = \code{"ROC"},
multi-class classification = \code{"logLoss"},
regression = \code{"RMSE"}.}

\item{class_probs}{Whether to use class probabilities (TRUE for categorical outcomes, FALSE for numeric outcomes).}

\item{method}{ML method.
Options: \code{c("glmnet", "rf", "rpart2", "svmRadial", "xgbTree")}.
\itemize{
\item glmnet: linear, logistic, or multiclass regression
\item rf: random forest
\item rpart2: decision tree
\item svmRadial: support vector machine
\item xgbTree: xgboost
}}

\item{seed}{Random seed (default: \code{NA}).
Your results will only be reproducible if you set a seed.}

\item{corr_thresh}{For feature importance, group correlations
above or equal to \code{corr_thresh} (range \code{0} to \code{1}; default: \code{1}).}

\item{groups}{Vector of feature names to group together during permutation.
Each element should be a string with feature names separated by a pipe
character (\code{|}). If this is \code{NULL} (default), correlated features will be
grouped together based on \code{corr_thresh}.}

\item{nperms}{number of permutations to perform (default: \code{100}).}

\item{corr_method}{correlation method. options or the same as those supported
by \code{stats::cor}: spearman, pearson, kendall. (default: spearman)}
}
\value{
Data frame with performance metrics for when each feature (or group
of correlated features; \code{names}) is permuted (\code{perf_metric}), differences
between the actual test performance metric on and the permuted performance
metric (\code{perf_metric_diff}; test minus permuted performance), and the
p-value (\code{pvalue}: the probability of obtaining the actual performance
value under the null hypothesis). Features with a larger \code{perf_metric_diff}
are more important. The performance metric name (\code{perf_metric_name}) and
seed (\code{seed}) are also returned.
}
\description{
Calculates feature importance using a trained model and test data. Requires
the \code{future.apply} package.
}
\details{
For permutation tests, the p-value is the number of permutation statistics
that are greater than the test statistic, divided by the number of
permutations. In our case, the permutation statistic is the model performance
(e.g. AUROC) after randomizing the order of observations for one feature, and
the test statistic is the actual performance on the test data. By default we
perform 100 permutations per feature; increasing this will increase the
precision of estimating the null distribution, but also increases runtime.
The p-value represents the probability of obtaining the actual performance in
the event that the null hypothesis is true, where the null hypothesis is that
the feature is not important for model performance.

We strongly recommend providing multiple cores to speed up computation time.
See \href{http://www.schlosslab.org/mikropml/articles/parallel.html}{our vignette on parallel processing}
for more details.
}
\examples{
\dontrun{
# If you called `run_ml()` with `feature_importance = FALSE` (the default),
# you can use `get_feature_importance()` later as long as you have the
# trained model and test data.
results <- run_ml(otu_small, "glmnet", kfold = 2, cv_times = 2)
names(results$trained_model$trainingData)[1] <- "dx"
feat_imp <- get_feature_importance(results$trained_model,
  results$trained_model$trainingData,
  results$test_data,
  "dx",
  multiClassSummary,
  "AUC",
  class_probs = TRUE,
  method = "glmnet"
)

# We strongly recommend providing multiple cores to speed up computation time.
# Do this before calling `get_feature_importance()`.
doFuture::registerDoFuture()
future::plan(future::multicore, workers = 2)

# Optionally, you can group features together with a custom grouping
feat_imp <- get_feature_importance(results$trained_model,
  results$trained_model$trainingData,
  results$test_data,
  "dx",
  multiClassSummary,
  "AUC",
  class_probs = TRUE,
  method = "glmnet",
  groups = c(
    "Otu00007", "Otu00008", "Otu00009", "Otu00011", "Otu00012",
    "Otu00015", "Otu00016", "Otu00018", "Otu00019", "Otu00020", "Otu00022",
    "Otu00023", "Otu00025", "Otu00028", "Otu00029", "Otu00030", "Otu00035",
    "Otu00036", "Otu00037", "Otu00038", "Otu00039", "Otu00040", "Otu00047",
    "Otu00050", "Otu00052", "Otu00054", "Otu00055", "Otu00056", "Otu00060",
    "Otu00003|Otu00002|Otu00005|Otu00024|Otu00032|Otu00041|Otu00053",
    "Otu00014|Otu00021|Otu00017|Otu00031|Otu00057",
    "Otu00013|Otu00006", "Otu00026|Otu00001|Otu00034|Otu00048",
    "Otu00033|Otu00010",
    "Otu00042|Otu00004", "Otu00043|Otu00027|Otu00049", "Otu00051|Otu00045",
    "Otu00058|Otu00044", "Otu00059|Otu00046"
  )
)

# the function can show a progress bar if you have the `progressr` package installed.
## optionally, specify the progress bar format:
progressr::handlers(progressr::handler_progress(
  format = ":message :bar :percent | elapsed: :elapsed | eta: :eta",
  clear = FALSE,
  show_after = 0
))
## tell progressr to always report progress
progressr::handlers(global = TRUE)
## run the function and watch the live progress udpates
feat_imp <- get_feature_importance(results$trained_model,
  results$trained_model$trainingData,
  results$test_data,
  "dx",
  multiClassSummary,
  "AUC",
  class_probs = TRUE,
  method = "glmnet"
)

# You can specify any correlation method supported by `stats::cor`:
feat_imp <- get_feature_importance(results$trained_model,
  results$trained_model$trainingData,
  results$test_data,
  "dx",
  multiClassSummary,
  "AUC",
  class_probs = TRUE,
  method = "glmnet",
  corr_method = "pearson"
)
}

}
\author{
Begüm Topçuoğlu, \email{topcuoglu.begum@gmail.com}

Zena Lapp, \email{zenalapp@umich.edu}

Kelly Sovacool, \email{sovacool@umich.edu}
}
