% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_models.R
\name{compare_models}
\alias{compare_models}
\title{Perform permutation tests to compare the performance metric
across all pairs of a group variable.}
\usage{
compare_models(merged_data, metric, group_name, nperm = 10000)
}
\arguments{
\item{merged_data}{the concatenated performance data from \code{run_ml}}

\item{metric}{metric to compare, must be numeric}

\item{group_name}{column with group variables to compare}

\item{nperm}{number of permutations, default=10000}
}
\value{
a table of p-values for all pairs of group variable
}
\description{
A wrapper for \code{permute_p_value()}.
}
\examples{
df <- dplyr::tibble(
  model = c("rf", "rf", "glmnet", "glmnet", "svmRadial", "svmRadial"),
  AUC = c(.2, 0.3, 0.8, 0.9, 0.85, 0.95)
)
set.seed(123)
compare_models(df, "AUC", "model", nperm = 10)
}
\author{
Courtney R Armour, \email{armourc@umich.edu}
}
