% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{rm_missing_outcome}
\alias{rm_missing_outcome}
\title{Remove missing outcome values}
\usage{
rm_missing_outcome(dataset, outcome_colname)
}
\arguments{
\item{dataset}{Data frame with an outcome variable and other columns as features.}

\item{outcome_colname}{Column name as a string of the outcome variable
(default \code{NULL}; the first column will be chosen automatically).}
}
\value{
dataset with no missing outcomes
}
\description{
Remove missing outcome values
}
\examples{
\dontrun{
rm_missing_outcome(mikropml::otu_mini_bin, "dx")

test_df <- mikropml::otu_mini_bin
test_df[1:100, "dx"] <- NA
rm_missing_outcome(test_df, "dx")
}
}
\author{
Zena Lapp, \email{zenalapp@umich.edu}
}
\keyword{internal}
