% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mimi.R
\name{mimi.lr}
\alias{mimi.lr}
\title{mimi.lr
Compute solution of mimi for low-rank model along regularization path}
\usage{
mimi.lr(y, var.type = c("gaussian", "binary", "poisson"), lambda1,
  maxit = 100, theta0 = NULL, thresh = 1e-05, trace.it = F,
  max.rank = NULL)
}
\arguments{
\item{y}{nxp observation matrix}

\item{var.type}{vector of length p indicating types of y columns (gaussian, binary, poisson)}

\item{lambda1}{positive number, regularization parameter for nuclear norm penalty}

\item{maxit}{integer, maximum number of iterations}

\item{theta0}{matrix of size nxp, initial interactions (optional)}

\item{thresh}{positive number, convergence criterion}

\item{trace.it}{boolean, whether convergence information should be printed}

\item{max.rank}{integer, maximum rank of interaction matrix}
}
\value{
A list with the following elements
\item{yimputed}{the imputed data set}
\item{theta}{estimated low-rank matrix}
}
\description{
mimi.lr
Compute solution of mimi for low-rank model along regularization path
}
\examples{
y0 <- matrix(rnorm(6 * 10), nrow = 6)
y0[sample(1:50, size = 10)] <- NA
var.type <- rep("gaussian", 10)
res <- mimi.lr(y0, var.type, lambda1 = 0.1)
}
