% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mimsy.save.R
\name{mimsy.save}
\alias{mimsy.save}
\title{\code{mimsy.save} Save output to an Excel workbook}
\usage{
mimsy.save(x, file)
}
\arguments{
\item{x}{object to be written to file, the output of `mimsy` function}

\item{file}{desired file name with .xlsx ending. Example: "mimsyCalculations.xlsx"}
}
\value{
Outputs an excel workbook to the user's working directory
}
\description{
Easily save the full output of the `mimsy` calculation function to a nicely-formatted, multi-tab Excel .xlsx file.
}
\examples{
data <-
  read.csv(file = system.file("extdata", "data.csv", package = "mimsy"),
           header = TRUE, stringsAsFactors = FALSE)

results <- mimsy(data, baromet.press = 981.2, units = 'hPa')

mimsy.save(results, file = file.path(tempdir(), "results.xlsx"))

}
