% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_from_reads.R
\name{search_from_fastq_reads}
\alias{search_from_fastq_reads}
\title{\code{search_from_fastq_reads}}
\usage{
search_from_fastq_reads(
  fastq_file,
  search_tables,
  skip_n_reads = 0,
  progress = TRUE,
  max_n_reads = -1,
  quality_offset = 33,
  output_temp_result = TRUE,
  temp_result_folder = "./temp_results",
  simplify_id = TRUE,
  output_read_length = TRUE,
  bp = MulticoreParam()
)
}
\arguments{
\item{fastq_file}{fastq file containing the runs to search from}

\item{search_tables}{a dataframe with the following columns:
- ["id"],"type",["sequence"],"strand","result","extra","match_ref_seq"}

\item{skip_n_reads}{number of reads to skip, default is 0}

\item{progress}{whether to show the progress bar}

\item{max_n_reads}{maximum number of reads to read, default to -1 (all)}

\item{quality_offset}{the quality offset to use, default to 33}

\item{output_temp_result}{whether to output the temporary results}

\item{temp_result_folder}{directory to output the temporary results}

\item{simplify_id}{simplify and shorten the read id to the first part}

\item{output_read_length}{whether to output the read length, NULL - do not output; csv - output to csv file; data - output to result}

\item{bp}{BiocParallel backend to use for parallelization}
}
\value{
will return a list of dataframe containing: -
`search_id`, `sequence`, `reads`, `raw_match`, `mean_qualities`, `indexes`.
}
\description{
\code{search_from_fastq_reads} identify the matches
from a list of search strings
}
