% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{select_n_set_i_depth}
\alias{select_n_set_i_depth}
\title{\code{select_n_set_i_depth}}
\usage{
select_n_set_i_depth(
  starting_positions = c(),
  excluded_positions = c(),
  seqc,
  metric,
  number_of_result = 1,
  max_depth = 1,
  seqc_length,
  bp = SerialParam(),
  ...
)
}
\arguments{
\item{starting_positions}{the starting positions that is already in
the SNP set.}

\item{excluded_positions}{excluded positions}

\item{seqc}{list of sequences, either passed directly from
\code{process_allele} or \code{read_fasta} or equivalence}

\item{metric}{either `simpson` or `percent`}

\item{number_of_result}{number of results to return, 0 will be coerced to 1}

\item{max_depth}{maximum depth to go before terminating,
0 means it will only calculate the metric for included position}

\item{seqc_length}{the length to iterate through.}

\item{bp}{BiocParallel backend.
Rule of thumbs: use MulticoreParam(workers = ncpus - 2)}

\item{...}{other parameters as needed}
}
\value{
Will return the resolution-optimised SNPs set, based on the metric.
}
\description{
\code{select_n_set_i_depth} is the actual function used to
find optimised SNPs set. This function is called by
\code{find_optimised_snps}, after preprocessing.
}
\keyword{internal}
