% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fires.R
\name{fires}
\alias{fires}
\title{Update Fire Dataset with Current Date}
\usage{
fires()
}
\value{
A data.table with updated dates, shifted to the current date
}
\description{
The \code{fires} function creates a copy of the fire dataset and adjusts the dates
to align with the current date while maintaining the original date patterns.
}
\details{
The function performs the following operations:
\itemize{
\item Creates a copy of the fire dataset from the mintyr package
\item Calculates the number of days between the last recorded date and the previous day
\item Shifts all dates forward by the calculated number of days
\item Converts the updated dates back to character format
}
}
\note{
\itemize{
\item Requires the \code{data.table} and \code{mintyr} packages
\item Uses the current system date as a reference for date shifting
\item Maintains the original structure of the date column
}
}
\examples{
head(fires())
}
