% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeSBMLmod.R
\name{writeSBMLmod}
\alias{writeSBMLmod}
\title{Write a model in SBML format}
\usage{
writeSBMLmod(modelData, modelID = "model", outputFile, boundary = "b")
}
\arguments{
\item{modelData}{A modelOrg or a data.frame object. If a data.frame is given, it must contain following mandatory colnames: \itemize{
\item \code{'ID':} A list of single character strings containing the reaction abbreviations, Entries in the field abbreviation are used as reaction ids, so they must be unique.
\item \code{'REACTION':} A set of stoichiometric reaction with the following characteristics: \itemize{
\item Arrows symbols must be given in the form \code{'=>'} or \code{'<=>'}
\item Inverse arrow symbols \code{'<='} or other types as: \code{'-->'}, \code{'<==>'}, \code{'->'} will not be parsed and will lead to errors.
\item Arrow symbols and plus signs (\code{+}) must be surrounded by a space character
\item Stoichiometric coefficients must be surrounded by a space character and not by parentheses.
\item Each metabolite must have only one stoichiometric coefficient, substituents must be joined to metabolite name by a hyphen (\code{-}) symbol.
\item Exchange reactions must have only one metabolite before arrow symbol
\item Compartments must be given between square brackets ([compartment]) joined at the end of metabolite name
}
Some examples of valid stoichiometric reactions are: \itemize{
\item \code{H2O[c] + Urea-1-Carboxylate[c] <=> 2 CO2[c] + 2 NH3[c]}
\item \code{ADP[c] + Phosphoenolpyruvate[c] => ATP[c] + Pyruvate[c]}
\item \code{CO2[c] <=> }
}
\item \code{'GPR':} A set of genes joined by boolean operators as AND or OR, rules may be nested by parenthesis. (optional: column can be empty),
\item \code{'LOWER.BOUND':} A list of numeric values containing the lower bounds of the reaction rates.
If not set, zero is used for an irreversible reaction and -1000 for a reversible reaction. (optional: column can be empty),
\item \code{'UPPER.BOUND':} A list of numeric values containing the upper bounds of the reaction rates.
If not set, 1000 is used by default. (optional: column can be empty),
\item \code{'OBJECTIVE':} A list of numeric values containing objective values (-1, 0 or 1) for each reaction (optional: column can be empty).
}}

\item{modelID}{A single character string giving the modelID}

\item{outputFile}{A writable path for the output 'SBML' file to be generate}

\item{boundary}{A single character string specifying the compartment to be used as boundary, \code{'b'} is used by default}
}
\value{
A valid SBML file
}
\description{
This function converts a data.frame or a modelOrg object to a valid SBML file. The Systems Biology Markup Language (SBML) is a representation format, based on XML, for communicating and storing computational models of biological processes.
}
\examples{
# Loading a metabolic model
glycolysis <- read.csv(system.file("extdata/glycolysisModel.csv",package = "minval"), sep='\\t')

# Writing a model in SBML format
writeSBMLmod(modelData = glycolysis,modelID = "Glycolysis",outputFile = "glycolysis.xml")

\dontrun{
# Writing a modelOrg object in a SBML format
## Loading the sybil R package
library(sybil)

## Loading the data
data("Ec_core")

## Writing the modelOrg object in a SBML format
writeSBMLmod(modelData = Ec_core,modelID = "E.coli",outputFile = "eColi.xml")
}
}
\author{
Daniel Camilo Osorio <dcosorioh@tamu.edu>
}
