% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{is_mirai_error}
\alias{is_mirai_error}
\alias{is_mirai_interrupt}
\alias{is_error_value}
\title{Error Validators}
\usage{
is_mirai_error(x)

is_mirai_interrupt(x)

is_error_value(x)
}
\arguments{
\item{x}{an object.}
}
\value{
Logical value TRUE or FALSE.
}
\description{
Validator functions for error value types created by \pkg{mirai}.
}
\details{
Is the object a 'miraiError'. When execution in a mirai process
    fails, the error message is returned as a character string of class
    'miraiError' and 'errorValue'. The stack trace is available at
    \code{$stack.trace} on the error object.

    Is the object a 'miraiInterrupt'. When an ongoing mirai is sent a user
    interrupt, the mirai will resolve to an empty character string classed as
    'miraiInterrupt' and 'errorValue'.

    Is the object an 'errorValue', such as a mirai timeout, a 'miraiError' or
    a 'miraiInterrupt'. This is a catch-all condition that includes all
    returned error values.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

m <- mirai(stop())
call_mirai(m)
is_mirai_error(m$data)
is_mirai_interrupt(m$data)
is_error_value(m$data)
m$data$stack.trace

m2 <- mirai(Sys.sleep(1L), .timeout = 100)
call_mirai(m2)
is_mirai_error(m2$data)
is_mirai_interrupt(m2$data)
is_error_value(m2$data)

}

}
