% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promises.R
\name{as.promise.mirai_map}
\alias{as.promise.mirai_map}
\title{Make mirai_map Promise}
\usage{
\method{as.promise}{mirai_map}(x)
}
\arguments{
\item{x}{an object of class 'mirai_map'.}
}
\value{
A 'promise' object.
}
\description{
Creates a 'promise' from a 'mirai_map'.
}
\details{
This function is an S3 method for the generic \code{as.promise()} for class
'mirai_map'.

Requires the \CRANpkg{promises} package.

Allows a 'mirai_map' to be used with the promise pipe \verb{\%...>\%}, which
schedules a function to run upon resolution of the entire 'mirai_map'.

The implementation internally uses \code{promises::promise_all()}. If all of the
promises were successful, the returned promise will resolve to a list of the
promise values; if any promise fails, the first error to be encountered will
be used to reject the returned promise.
}
\examples{
\dontshow{if (interactive() && requireNamespace("promises", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(promises)

with(daemons(1), {
  mp <- mirai_map(1:3, function(x) { Sys.sleep(1); x })
  p <- as.promise(mp)
  print(p)
  p \%...>\% print
  mp[.flat]
})
\dontshow{\}) # examplesIf}
}
