% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai-package.R
\docType{package}
\encoding{UTF-8}
\name{mirai-package}
\alias{mirai-package}
\title{mirai: Minimalist Async Evaluation Framework for R}
\description{
Designed for simplicity, a 'mirai' evaluates an R expression asynchronously
in a parallel process, locally or distributed over the network. The result is
automatically available upon completion. Modern networking and concurrency,
built on 'nanonext' and 'NNG' (Nanomsg Next Gen), ensures reliable and
efficient scheduling over fast inter-process communications or TCP/IP secured
by TLS. Distributed computing can launch remote resources via SSH or cluster
managers. An inherently queued architecture handles many more tasks than
available processes, and requires no storage on the file system. Innovative
features include support for otherwise non-exportable reference objects,
event-driven promises, and asynchronous parallel map.
}
\section{Notes}{


For local mirai requests, the default transport for inter-process
communications is platform-dependent: abstract Unix domain sockets on Linux,
Unix domain sockets on MacOS, Solaris and other POSIX platforms, and named
pipes on Windows.

This may be overriden, if desired, by specifying 'url' in the
\code{\link[=daemons]{daemons()}} interface and launching daemons using
\code{\link[=launch_local]{launch_local()}}.
}

\section{Reference Manual}{


\code{vignette("mirai", package = "mirai")}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://shikokuchuo.net/mirai/}
  \item \url{https://github.com/shikokuchuo/mirai}
  \item Report bugs at \url{https://github.com/shikokuchuo/mirai/issues}
}

}
\author{
Charlie Gao \email{charlie.gao@shikokuchuo.net}
(\href{https://orcid.org/0000-0002-0750-061X}{ORCID})
}
