context('mirtTwo')

test_that('poly', {
    modp1 <- mirt(Science, 1, SE = FALSE)
    expect_is(modp1, 'ConfirmatoryClass')          
    modp2 <- mirt(Science, 2)
    expect_is(modp2, 'ExploratoryClass')
    modp3 <- mirt(Science, 1, constrain = list(c(1,5)), parprior = list(c(2,'norm',0,1)))
    expect_is(modp3, 'ConfirmatoryClass')
    modp4 <- mirt(Science, 1, itemtype = c(rep('graded',3), 'mcm'), SE = FALSE)
    expect_is(modp4, 'ConfirmatoryClass')
    
    fm1 <- fscores(modp1, verbose = FALSE)
    expect_is(fm1, 'matrix')
    fm2 <- fscores(modp2, rotate = 'oblimin', verbose = FALSE)
    expect_is(fm2, 'matrix')
    fm3 <- fscores(modp3, rotate = 'oblimin', full.scores = TRUE, verbose = FALSE)
    expect_is(fm3, 'matrix')
    fm4 <- fscores(modp4, verbose = FALSE)
    expect_is(fm4, 'matrix')
    
    cof1 <- coef(modp1, verbose = FALSE)
    expect_is(cof1, 'list')
    cof2 <- coef(modp2, verbose = FALSE)
    expect_is(cof2, 'list')
    IP1 <- itemplot(modp1, 1)
    IP2 <- itemplot(modp2, 1)
    expect_is(IP1, 'NULL')
    expect_is(IP2, 'trellis')
})