% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagrange.R
\name{lagrange}
\alias{lagrange}
\title{Lagrange test for freeing parameters}
\usage{
lagrange(mod, parnum, SE.type = "Oakes", type = "central", ...)
}
\arguments{
\item{mod}{an estimated model}

\item{parnum}{a vector, or list of vectors, containing one or more parameter
locations/sets of locations to be tested.
See objects returned from \code{\link{mod2values}} for the locations}

\item{SE.type}{type of information matrix estimator to use. See \code{\link{mirt}} for
further details}

\item{type}{type of numerical algorithm passed to \code{\link{numerical_deriv}} to
obtain the gradient terms}

\item{...}{additional arguments to pass to \code{\link{mirt}}}
}
\description{
Lagrange (i.e., score) test to test whether parameters should be freed from a
more constrained baseline model.
}
\examples{

\dontrun{
dat <- expand.table(LSAT7)
mod <- mirt(dat, 1, 'Rasch')
(values <- mod2values(mod))

#test all fixed slopes individually
parnum <- values$parnum[values$name == 'a1']
lagrange(mod, parnum)

# compare to LR test for first two slopes
mod2 <- mirt(dat, 'F = 1-5
                   FREE = (1, a1)', 'Rasch')
coef(mod2, simplify=TRUE)$items
anova(mod, mod2)

mod2 <- mirt(dat, 'F = 1-5
                   FREE = (2, a1)', 'Rasch')
coef(mod2, simplify=TRUE)$items
anova(mod, mod2)

mod2 <- mirt(dat, 'F = 1-5
                   FREE = (3, a1)', 'Rasch')
coef(mod2, simplify=TRUE)$items
anova(mod, mod2)

# test slopes first two slopes and last three slopes jointly
lagrange(mod, list(parnum[1:2], parnum[3:5]))

# test all 5 slopes and first + last jointly
lagrange(mod, list(parnum[1:5], parnum[c(1, 5)]))

}
}
\seealso{
\code{\link{wald}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{Lagrange}
\keyword{test}
