% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.miss.glm.R
\name{predict.miss.glm}
\alias{predict.miss.glm}
\title{Prediction on test with missing values for the logistic regression model.}
\usage{
\method{predict}{miss.glm}(object, newdata = NULL, seed = NA, method = "map", ...)
}
\arguments{
\item{object}{a fitted object of class inheriting from "miss.glm".}

\item{newdata}{a data frame in which to look for variables with which to predict. It can contain missing values.}

\item{seed}{An integer as a seed set for the random generator.}

\item{method}{The name of method to deal with missing values in test set. It can be 'map'(maximum a posteriori) or 'impute' (imputation by conditional expectation). Default is 'map'.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
\item{pr.saem}{The prediction result for logistic regression: the probability of response y=1.}
}
\description{
Prediction on test with missing values for the logistic regression model.
}
\examples{
# Generate dataset
N <- 100  # number of subjects
p <- 3     # number of explanatory variables
mu.star <- rep(0,p)  # mean of the explanatory variables
Sigma.star <- diag(rep(1,p)) # covariance
beta.star <- c(1, 1,  0) # coefficients
beta0.star <- 0 # intercept
beta.true = c(beta0.star,beta.star)
X.complete <- matrix(rnorm(N*p), nrow=N)\%*\%chol(Sigma.star) +
              matrix(rep(mu.star,N), nrow=N, byrow = TRUE)
p1 <- 1/(1+exp(-X.complete\%*\%beta.star-beta0.star))
y <- as.numeric(runif(N)<p1)

# Generate missingness
p.miss <- 0.10
patterns <- runif(N*p)<p.miss #missing completely at random
X.obs <- X.complete
X.obs[patterns] <- NA

df.obs = data.frame(y,X.obs)

# SAEM
miss.list = miss.glm(y~., data=df.obs, print_iter=FALSE,seed=100)

# Generate new dataset for prediction
Nt <- 20
Xt <- matrix(rnorm(Nt*p), nrow=Nt)\%*\%chol(Sigma.star)+
  matrix(rep(mu.star,Nt), nrow=Nt, byrow = TRUE)
# Generate missingness in new dataset
patterns <- runif(Nt*p)<p.miss
Xt.obs <- Xt
Xt.obs[patterns] <- NA

# Prediction with missing values
miss.prob = predict(miss.list, data.frame(Xt.obs), method='map')
print(miss.prob)
}
