% Generated by roxygen2 (4.0.1): do not edit by hand
\name{textable}
\alias{textable}
\title{Table to Latex}
\usage{
textable(d, file, caption = NULL, rownames = FALSE, landscape = FALSE,
  pt.size = 10, margin = 2, digits = NULL, align = NULL, label = NULL)
}
\arguments{
\item{d}{Object to transform to a latex table.}

\item{file}{Character string with output file name. If missing or \code{""},
the output is printed to the screen.}

\item{caption}{Character vector with title of table.}

\item{rownames}{Logical, include row names of \code{d}.}

\item{landscape}{Logical, use a landscape format for wider tables.}

\item{pt.size}{Integer from 10 to 13 for the size of the characters.}

\item{margin}{Margin between table and page border in cm.}

\item{digits}{Number of digits to print from numeric values.}

\item{align}{Character vector with \code{'l'}, \code{'c'}, \code{'r'}
for aligning the columns left, centered or right. Length is either one
or 1 (for rownames column) + number of columns in \code{d} (even if
\code{rownames = FALSE})}

\item{label}{Character vector with the latex label or HTML anchor.}
}
\value{
Creates a file at the path given in \code{file} containting the latex code
with the table and document structure for an A4 latex article.
}
\description{
This function enhances \code{xtable} as it writes the latex code to a file
and adds a header/footer for the document structure to allow a direct
creation of a pdf with for example pdflatex.
}
\examples{
#

textable(head(trees), rownames=TRUE, digits=4, caption='R "trees" dataset.')

#
}
\author{
Sven E. Templer (\email{sven.templer@gmail.com})
}
\seealso{
\link{xtable}
}

