% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makePOIprelim.R
\name{makePOIprelim}
\alias{makePOIprelim}
\title{Make POI preliminary investigation data simulations: a function for obtaining a database of preliminary investigation data for a missing child search.}
\usage{
makePOIprelim(
  dateinit = "1975/01/01",
  scenario = 1,
  femaleprop = 0.5,
  ext = 100,
  numsims = 10000,
  seed = 123,
  birthprob = c(0.09, 0.9, 0.01),
  region = c("Cuyo", "Patagonia", "Central region", "North west region", "Litoral",
    "Buenos Aires"),
  regionprob = c(0.1, 0.1, 0.1, 0.1, 0.1, 0.5)
)
}
\arguments{
\item{dateinit}{Minimun birth date of simulated persons of interest.}

\item{scenario}{Birth date distribution scenarios: (1) non-uniform, (2) uniform.}

\item{femaleprop}{Proportion of females.}

\item{ext}{Time extension for minimun birth date, rang in scenario 1 and days in scenario 2.}

\item{numsims}{Number of simulated POIs.}

\item{seed}{Select a seed for simulations. If it is defined, results will be reproducible. Suggested, seed = 123}

\item{birthprob}{Birth type probabilities: home birth, hospital birth and unknown-adoption.}

\item{region}{Birth region or place, argentine regions are listed as default.}

\item{regionprob}{Birth region or place proportions.}
}
\value{
An object of class data.frame with preliminary investigation data.
}
\description{
Make POI preliminary investigation data simulations: a function for obtaining a database of preliminary investigation data for a missing child search.
}
\examples{
makePOIprelim(
  dateinit = "1975/01/01",
  scenario = 1,
  femaleprop = 0.5,
  ext = 100,
  numsims = 10000,
  seed = 123,
  birthprob = c(0.09, 0.9, 0.01),
  region = c("Cuyo", "Patagonia", "Central region", "North west region", "Litoral",
            "Buenos Aires"),
  regionprob = c(0.1, 0.1, 0.1, 0.1, 0.1, 0.5)
  )
}
