% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SBM_sampler-Class.R
\docType{data}
\name{SBM_sampler}
\alias{SBM_sampler}
\title{An R6 Class to represent a sampler for a SBM}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
SBM_sampler
}
\description{
The function \code{\link{simulate}} produces an instance of an object with class \code{SBM_sampler}.
}
\details{
All fields of this class are only accessible for reading. This class comes with a set of methods,
some of them being useful for the user (see examples)
\itemize{
\item{R6 methods:}{$rBlocks(), $rAdjancencyMatrix()}
\item{S3 methods}{print(), plot()}
}
}
\section{Fields}{

\describe{
\item{\code{nNodes}}{The number of nodes}

\item{\code{nBlocks}}{The number of blocks}

\item{\code{nCovariates}}{The number of covariates}

\item{\code{nDyads}}{The number of possible dyad in the network (depends on the direction)}

\item{\code{direction}}{A character indicating if the network is directed or undirected}

\item{\code{hasCovariates}}{a boolean indicating if the model has covariates}

\item{\code{mixtureParam}}{the vector of mixture parameters}

\item{\code{connectParam}}{the matrix of connectivity: inter/intra probabilities of connection when the network does not have covariates, or a logit scaled version of it.}

\item{\code{covarParam}}{the vector of parameters associated with the covariates}

\item{\code{covarArray}}{the array of covariates}
}}

\examples{
## SBM parameters
directed <- FALSE
N <- 300 # number of nodes
Q <- 3   # number of clusters
alpha <- rep(1,Q)/Q     # mixture parameter
pi <- diag(.45,Q) + .05 # connectivity matrix
gamma <- log(pi/(1-pi)) # logit transform fo the model with covariates
M <- 2 # two Gaussian covariates
covarMatrix <- matrix(rnorm(N*M,mean = 0, sd = 1), N, M)
covarParam  <- rnorm(M, -1, 1)

## draw a SBM without covariates through simulateSBM
sbm <- missSBM::simulate(N, alpha, pi, directed)

## equivalent construction from the SBM_sampler class itslef
sbm_s <- SBM_sampler$new(directed, N, alpha, pi)
sbm_s$rBlocks() # draw some blocks
sbm_s$rAdjMatrix() # draw some edges

}
\seealso{
The function \code{\link{simulate}}.
}
\keyword{datasets}
