% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqr_new.R
\name{GPD}
\alias{GPD}
\alias{dGPD}
\alias{pGPD}
\alias{qGPD}
\alias{rGPD}
\title{The Generalized Pareto Distribution}
\usage{
dGPD(x, loc = 0, scale = 1, shape = 0, log = FALSE)

pGPD(q, loc = 0, scale = 1, shape = 0, lower.tail = TRUE,
  log.p = FALSE)

qGPD(p, loc = 0, scale = 1, shape = 0, lower.tail = TRUE,
  log.p = FALSE)

rGPD(n, loc = 0, scale = 1, shape = 0)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{loc}{location parameter.}

\item{scale}{scale parameter.}

\item{shape}{shape parameter.}

\item{log, log.p}{logical; if TRUE, probabilities \eqn{p} are given as \eqn{log(p)}, default: FALSE.}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}, default: TRUE.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dGPD} gives the density, \code{pGPD} gives the distribution function, \code{qGPD} gives the quantile function, and
        \code{rGPD} generates random deviates.

        Invalid arguments will result in return value NaN, with a warning.
}
\description{
Density, distribution function, quantile function and random generation for the generalized Pareto distribution with
location, scale and shape parameters.
}
\details{
The generalized Pareto distribution function with location parameter \eqn{\mu}, scale parameter \eqn{\sigma}
         and shape parameter \eqn{\xi} has density given by
         \deqn{f(x)=1/\sigma  (1 + \xi z)^-(1/\xi + 1)} for \eqn{x\ge \mu} and \eqn{\xi> 0},
         or \eqn{\mu-\sigma/\xi \ge x\ge \mu} and \eqn{\xi< 0},
         where \eqn{z=(x-\mu)/\sigma}. In the case where \eqn{\xi= 0}, the density is equal to
         \eqn{f(x)=1/\sigma  e^-z} for \eqn{x\ge \mu}.
         The cumulative distribution function is
         \deqn{F(x)=1-(1+\xi z)^(-1/\xi)} for \eqn{x\ge \mu} and \eqn{\xi> 0},
         or \eqn{\mu-\sigma/\xi \ge x\ge \mu} and \eqn{\xi< 0},
         with \eqn{z} as stated above. If \eqn{\xi= 0} the CDF has form \eqn{F(x)=1-e^-z}.

         See \url{https://en.wikipedia.org/wiki/Generalized_Pareto_distribution} for more details.
}
\examples{
dGPD(seq(1, 5), 0, 1, 1)
qGPD(pGPD(seq(1, 5), 0, 1, 1), 0, 1 ,1)
rGPD(5, 0, 1, 1)
}
\seealso{
\code{\link{GPDdist}}
}
