% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.prop.R
\name{na.prop}
\alias{na.prop}
\title{Proportion of Missing Data for Each Case}
\usage{
na.prop(x, digits = 2, as.na = NULL, check = TRUE)
}
\arguments{
\item{x}{a matrix or data frame.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying
proportions.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns a numeric vector with the same length as the number of rows in \code{x} containing the
proportion of missing data.
}
\description{
This function computes the proportion of missing data for each case in a matrix or data frame.
}
\examples{
dat <- data.frame(x = c(1, NA, NA, 6, 3),
                  y = c(7, NA, 8, 9, NA),
                  z = c(2, NA, 3, NA, 5))

# Compute proportion of missing data (\code{NA}) for each case in the data frame
na.prop(dat)
}
\references{
Enders, C. K. (2010). \emph{Applied missing data analysis}. Guilford Press.

Graham, J. W. (2009). Missing data analysis: Making it work in the real world.
\emph{Annual Review of Psychology, 60}, 549-576. https://doi.org/10.1146/annurev.psych.58.110405.085530

van Buuren, S. (2018). \emph{Flexible imputation of missing data} (2nd ed.). Chapman & Hall.
}
\seealso{
\code{\link{as.na}}, \code{\link{na.as}}, \code{\link{na.auxiliary}}, \code{\link{na.coverage}},
\code{\link{na.descript}}, \code{\link{na.indicator}}, \code{\link{na.pattern}}.
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
