% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.scores.R
\name{group.scores}
\alias{group.scores}
\title{Group Scores}
\usage{
group.scores(x, group, fun = c("mean", "sum", "median", "var", "sd", "min", "max"),
             expand = TRUE, as.na = NULL, check = TRUE)
}
\arguments{
\item{x}{a numeric vector.}

\item{group}{a integer vector, character vector, or factor representing the grouping structure (i.e., group variable).}

\item{fun}{character string indicating the function used to compute group scores, default: \code{"mean"}.}

\item{expand}{logical: if \code{TRUE}, vector of group scores is expanded to match the input vector \code{x}.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.
Note that \code{as.na()} function is only applied to the argument \code{x},
but not to \code{group}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns a numeric vector containing group scores with the same length as \code{x} if \code{expand = TRUE}
or with the length \code{length(unique(group))} if \code{expand = FALSE}.
}
\description{
This function computes group means by default.
}
\examples{
dat.ml <- data.frame(id = c(1, 2, 3, 4, 5, 6, 7, 8, 9),
                     group = c(1, 1, 1, 2, 2, 2, 3, 3, 3),
                     x = c(4, 2, 5, 6, 3, 4, 1, 3, 4))

# Compute group means and expand to match the input x
group.scores(dat.ml$x, group = dat.ml$group)

# Compute standard deviation for each group and expand to match the input x
group.scores(dat.ml$x, group = dat.ml$group, fun = "sd")

# Compute group means without expanding the vector
group.scores(dat.ml$x, group = dat.ml$group, expand = FALSE)
}
\references{
Hox, J., Moerbeek, M., & van de Schoot, R. (2018). \emph{Multilevel analysis: Techniques and applications} (3rd. ed.).
Routledge.

Snijders, T. A. B., & Bosker, R. J. (2012). \emph{Multilevel analysis: An introduction to basic and advanced multilevel
modeling} (2nd ed.). Sage Publishers.
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}

#' @seealso
\code{\link{scores}}, \code{\link{multilevel.descript}}, \code{\link{multilevel.icc}}
}
