% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stromit.R
\name{stromit}
\alias{stromit}
\title{Omit Strings}
\usage{
stromit(x, omit = "", na.omit = FALSE, check = TRUE)
}
\arguments{
\item{x}{a numeric vector, character vector or factor.}

\item{omit}{a numeric vector or character vector indicating values or strings to be omitted
from the vector \code{x}, the default setting is the empty strings \code{""}.}

\item{na.omit}{logical: if \code{TRUE}, missing values (\code{NA}) are also omitted from the
vector.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns a numeric vector, character vector or factor with values or strings
specified in \code{omit} omitted from the vector specified in \code{x}.
}
\description{
This function omits user-specified values or strings from a numeric vector, character vector or factor.
}
\examples{
#--------------------------------------
# Charater vector
x.chr <- c("a", "", "c", NA, "", "d", "e", NA)

# Omit character string ""
stromit(x.chr)

# Omit character string "" and missing values (NA)
stromit(x.chr, na.omit = TRUE)

# Omit character string "c" and "e"
stromit(x.chr, omit = c("c", "e"))

# Omit character string "c", "e", and missing values (NA)
stromit(x.chr, omit = c("c", "e"), na.omit = TRUE)

#--------------------------------------
# Numeric vector
x.num <- c(1, 2, NA, 3, 4, 5, NA)

# Omit values 2 and 4
stromit(x.num, omit = c(2, 4))

# Omit values 2, 4, and missing values (NA)
stromit(x.num, omit = c(2, 4), na.omit = TRUE)

#--------------------------------------
# Factor
x.factor <- factor(letters[1:10])

# Omit factor levels "a", "c", "e", and "g"
stromit(x.factor, omit = c("a", "c", "e", "g"))
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
