% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.ci.R
\name{print.ci}
\alias{print.ci}
\title{Print ci object}
\usage{
\method{print}{ci}(x, sort.var = x$args$sort.var, digits = x$args$digits, check = TRUE, ...)
}
\arguments{
\item{x}{\code{ci} object.}

\item{sort.var}{logical: if \code{TRUE}, output is sorted by variables.}

\item{digits}{an integer value indicating the number of decimal places to be used.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{ci} object
}
\examples{
dat <- data.frame(x = c(3, 2, 4, 5, 1, 6, 7, 4),
                  group = c(1, 1, 1, 1, 2, 2, 2, 2),
                  stringsAsFactors = FALSE)

# Two-Sided 95\% Confidence Interval for x
dat.mean <- ci.mean(dat$x, output = FALSE)

# Print ci object with 3 digits
print(dat.mean, digits = 3)
}
\seealso{
\code{\link{ci.mean}}, \code{\link{ci.mean.diff}}, \code{\link{ci.median}},
\code{\link{ci.prop}}, \code{\link{ci.var}}, \code{\link{ci.sd}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
