% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/script.save.R
\name{script.save}
\alias{script.save}
\title{Save R Script in RStudio}
\usage{
script.save(all = FALSE, check = TRUE)
}
\arguments{
\item{all}{logical: if \code{TRUE}, all scripts opened in RStudio are saved.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\description{
This function is used to save the current or all R scripts in RStudio.
}
\details{
The function \code{documentSave()} or \code{documentSaveAll()} in the package
\pkg{rstudioapi} is used to save the R script. Note that R scripts need to
have a file location before this function can be used.
}
\examples{
\dontrun{

# Save current R script
script.save()

# Save all R scripts
script.save(all = TRUE)
}
}
\references{
Ushey, K., Allaire, J., Wickham, H., & Ritchie, G. (2022). rstudioapi: Safely
access the RStudio API. R package version 0.14.
https://CRAN.R-project.org/package=rstudioapi
}
\seealso{
\code{\link{script.close}}, \code{\link{script.new}}, \code{\link{script.open}},
\code{\link{setsource}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
