% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.mixedMemModel}
\alias{plot.mixedMemModel}
\title{Plot a Mixed Membership Model}
\usage{
\method{plot}{mixedMemModel}(x, type = "theta", compare = NULL,
  main = NULL, varNames = NULL, groupNames = NULL, nrow = NULL,
  ncol = NULL, indices = NULL, fitNames = NULL, ...)
}
\arguments{
\item{x}{the mixedMemModel object to be plotted}

\item{type}{which estimated parameters to plot; either "theta" or "membership"}

\item{compare}{model to compare. For type = "theta", compare should be an array the same size as x$theta
for type = "membership", compare should be a matrix the same size as x$phi}

\item{main}{title for chart}

\item{varNames}{vector of names for each variable if plotting theta}

\item{groupNames}{vector of labels for each sub-population}

\item{nrow}{number of rows for the grid of plots}

\item{ncol}{number of columns for the grid of plots. if plotting theta, this
must be K, if plotting membership, this can be specified}

\item{indices}{when plotting memberships, which individuals to plot. When plotting theta, which variables to plot}

\item{fitNames}{vector of labels for each fit}

\item{...}{additional parameters}
}
\description{
Visual representation of a mixedMemModel object
}
\seealso{
mixedMemModel, vizTheta, vizMem
}

