% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixgb.R
\name{mixgb}
\alias{mixgb}
\title{Multiple imputation through XGBoost}
\usage{
mixgb(
  data,
  m = 5,
  maxit = 1,
  ordinalAsInteger = TRUE,
  bootstrap = TRUE,
  pmm.type = "auto",
  pmm.k = 5,
  pmm.link = "prob",
  initial.num = "normal",
  initial.int = "mode",
  initial.fac = "mode",
  save.models = FALSE,
  save.vars = NULL,
  verbose = F,
  xgb.params = list(max_depth = 6, gamma = 0, eta = 0.3, min_child_weight = 1,
    subsample = 1, colsample_bytree = 1, colsample_bylevel = 1, colsample_bynode = 1,
    tree_method = "auto", gpu_id = 0, predictor = "auto"),
  nrounds = 50,
  early_stopping_rounds = 1,
  print_every_n = 10L,
  xgboost_verbose = 0,
  ...
)
}
\arguments{
\item{data}{A data.frame or data.table with missing values}

\item{m}{The number of imputed datasets. Default: 5}

\item{maxit}{The number of imputation iterations. Default: 1}

\item{ordinalAsInteger}{Whether to convert ordinal factors to integers. The default setting \code{ordinalAsInteger = TRUE} can speed up the imputation process.}

\item{bootstrap}{Whether to use bootstrapping for multiple imputation. By default, \code{bootstrap = TRUE}. If \code{FALSE}, users are recommended to specify sampling-related hyperparameters of XGBoost to obtain imputations with adequate variability.}

\item{pmm.type}{The types of predictive mean matching (PMM). Possible values:
\itemize{
 \item \code{NULL}: Imputations without PMM;
 \item \code{0}: Imputations with PMM type 0;
 \item \code{1}: Imputations with PMM type 1;
 \item \code{2}: Imputations with PMM type 2;
 \item \code{"auto"} (Default): Imputations with PMM type 2 for numeric/integer variables; imputations without PMM for categorical variables.
}}

\item{pmm.k}{The number of donors for predictive mean matching. Default: 5}

\item{pmm.link}{The link for predictive mean matching binary variables
\itemize{
 \item \code{"prob"} (Default): use probabilities;
 \item \code{"logit"}: use logit values.
}}

\item{initial.num}{Initial imputation method for numeric type data:
\itemize{
 \item \code{"normal"} (Default);
 \item \code{"mean"};
 \item \code{"median"};
 \item \code{"mode"};
 \item \code{"sample"}.
}}

\item{initial.int}{Initial imputation method for integer type data:
\itemize{
 \item \code{"mode"} (Default);
 \item \code{"sample"}.
}}

\item{initial.fac}{Initial imputation method for factor type data:
\itemize{
 \item \code{"mode"} (Default);
 \item \code{"sample"}.
}}

\item{save.models}{Whether to save models for imputing new data later on. Default: \code{FALSE}}

\item{save.vars}{Response models for variables specified in \code{save.vars} will be saved for imputing new data. Can be a vector of names or indices. By default, \code{save.vars = NULL}, response models for variables with missing values will be saved. To save all models, please specify \code{save.vars = colnames(data)}.}

\item{verbose}{Verbose setting for mixgb. If \code{TRUE}, will print out the progress of imputation. Default: \code{FALSE}.}

\item{xgb.params}{A list of XGBoost parameters. For more details, please check \href{https://xgboost.readthedocs.io/en/stable/parameter.html}{XGBoost documentation on parameters}.}

\item{nrounds}{The maximum number of boosting iterations for XGBoost. Default: 50}

\item{early_stopping_rounds}{An integer value \code{k}. XGBoost training will stop if the validation performance hasn't improved for \code{k} rounds. Default: 10.}

\item{print_every_n}{Print XGBoost evaluation information at every nth iteration if \code{xgboost_verbose > 0}.}

\item{xgboost_verbose}{Verbose setting for XGBoost training: 0 (silent), 1 (print information) and 2 (print additional information). Default: 0}

\item{...}{Extra arguments to pass to XGBoost}
}
\value{
If \code{save.models = FALSE}, will return a list of \code{m} imputed datasets. If \code{save.models = TRUE}, will return an object with imputed datasets, saved models and parameters.
}
\description{
Obtain multiply imputed datasets using XGBoost, with an option to save models for imputing new data later on. Users can choose different settings regarding bootstrapping and predictive mean matching as well as XGBoost hyperparameters.
}
\examples{
# obtain m multiply datasets without saving models
mixgb.data <- mixgb(data = nhanes3, m = 2)

# obtain m multiply imputed datasets and save models for imputing new data later on
mixgb.obj <- mixgb(data = nhanes3, m = 2, save.models = TRUE)
}
