% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_new.R
\name{impute_new}
\alias{impute_new}
\title{Impute new data with a saved \code{mixgb} imputer object}
\usage{
impute_new(
  object,
  newdata,
  initial.newdata = FALSE,
  pmm.k = NULL,
  m = NULL,
  verbose = FALSE
)
}
\arguments{
\item{object}{A saved imputer object created by \code{mixgb(..., save.models = TRUE)}}

\item{newdata}{A data.frame or data.table. New data with missing values.}

\item{initial.newdata}{Whether to use the information from the new data to initially impute the missing values of the new data. By default, this is set to \code{FALSE}, the original data passed to \code{mixgb()} will be used for initial imputation.}

\item{pmm.k}{The number of donors for predictive mean matching. If \code{NULL} (the default), the \code{pmm.k} value in the saved imputer object will be used.}

\item{m}{The number of imputed datasets. If \code{NULL} (the default), the \code{m} value in the saved imputer object will be used.}

\item{verbose}{Verbose setting for mixgb. If \code{TRUE}, will print out the progress of imputation. Default: \code{FALSE}.}
}
\value{
A list of \code{m} imputed datasets for new data.
}
\description{
Impute new data with a saved \code{mixgb} imputer object
}
\examples{
set.seed(2022)
n <- nrow(nhanes3)
idx <- sample(1:n, size = round(0.7 * n), replace = FALSE)
train.data <- nhanes3[idx, ]
test.data <- nhanes3[-idx, ]

params <- list(max_depth = 3, subsample = 0.7, nthread = 2)
mixgb.obj <- mixgb(data = train.data, m = 2, xgb.params = params, nrounds = 10, save.models = TRUE)

# obtain m imputed datasets for train.data
train.imputed <- mixgb.obj$imputed.data
train.imputed

# use the saved imputer to impute new data
test.imputed <- impute_new(object = mixgb.obj, newdata = test.data)
test.imputed
}
